/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.RectF;
import android.graphics.Region;
import android.view.MotionEvent;
import java.util.ArrayList;
import java.util.List;
import org.osmdroid.util.BoundingBoxE6;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.OverlayWithIW;

public class Polygon
extends OverlayWithIW {
    private LinearRing mOutline;
    private ArrayList<LinearRing> mHoles;
    protected Paint mFillPaint;
    protected Paint mOutlinePaint;
    private final Path mPath = new Path();
    private final Point mTempPoint1 = new Point();
    private final Point mTempPoint2 = new Point();

    public Polygon(Context ctx) {
        super(ctx);
        this.mFillPaint = new Paint();
        this.mFillPaint.setColor(0);
        this.mFillPaint.setStyle(Paint.Style.FILL);
        this.mOutlinePaint = new Paint();
        this.mOutlinePaint.setColor(-16777216);
        this.mOutlinePaint.setStrokeWidth(10.0f);
        this.mOutlinePaint.setStyle(Paint.Style.STROKE);
        this.mOutlinePaint.setAntiAlias(true);
        this.mOutline = new LinearRing();
        this.mHoles = new ArrayList(0);
        this.mPath.setFillType(Path.FillType.EVEN_ODD);
    }

    public int getFillColor() {
        return this.mFillPaint.getColor();
    }

    public int getStrokeColor() {
        return this.mOutlinePaint.getColor();
    }

    public float getStrokeWidth() {
        return this.mOutlinePaint.getStrokeWidth();
    }

    public Paint getOutlinePaint() {
        return this.mOutlinePaint;
    }

    public List<GeoPoint> getPoints() {
        return this.mOutline.getPoints();
    }

    public boolean isVisible() {
        return this.isEnabled();
    }

    public void setFillColor(int fillColor) {
        this.mFillPaint.setColor(fillColor);
    }

    public void setStrokeColor(int color) {
        this.mOutlinePaint.setColor(color);
    }

    public void setStrokeWidth(float width) {
        this.mOutlinePaint.setStrokeWidth(width);
    }

    public void setVisible(boolean visible) {
        this.setEnabled(visible);
    }

    public void setPoints(List<GeoPoint> points) {
        this.mOutline.setPoints(points);
    }

    public void setHoles(List<? extends List<GeoPoint>> holes) {
        this.mHoles = new ArrayList(holes.size());
        for (List<GeoPoint> list : holes) {
            LinearRing newHole = new LinearRing();
            newHole.setPoints(list);
            this.mHoles.add(newHole);
        }
    }

    public List<ArrayList<GeoPoint>> getHoles() {
        ArrayList<ArrayList<GeoPoint>> result = new ArrayList<ArrayList<GeoPoint>>(this.mHoles.size());
        for (LinearRing hole : this.mHoles) {
            result.add(hole.getPoints());
        }
        return result;
    }

    public static ArrayList<GeoPoint> pointsAsCircle(GeoPoint center, double radiusInMeters) {
        ArrayList<GeoPoint> circlePoints = new ArrayList<GeoPoint>(60);
        for (int f = 0; f < 360; f += 6) {
            GeoPoint onCircle = center.destinationPoint(radiusInMeters, f);
            circlePoints.add(onCircle);
        }
        return circlePoints;
    }

    public static ArrayList<GeoPoint> pointsAsRect(BoundingBoxE6 rectangle) {
        ArrayList<GeoPoint> points = new ArrayList<GeoPoint>(4);
        points.add(new GeoPoint(rectangle.getLatNorthE6(), rectangle.getLonWestE6()));
        points.add(new GeoPoint(rectangle.getLatNorthE6(), rectangle.getLonEastE6()));
        points.add(new GeoPoint(rectangle.getLatSouthE6(), rectangle.getLonEastE6()));
        points.add(new GeoPoint(rectangle.getLatSouthE6(), rectangle.getLonWestE6()));
        return points;
    }

    public static ArrayList<GeoPoint> pointsAsRect(GeoPoint center, double lengthInMeters, double widthInMeters) {
        ArrayList<GeoPoint> points = new ArrayList<GeoPoint>(4);
        GeoPoint east = center.destinationPoint(lengthInMeters * 0.5, 90.0f);
        GeoPoint south = center.destinationPoint(widthInMeters * 0.5, 180.0f);
        int westLon = center.getLongitudeE6() * 2 - east.getLongitudeE6();
        int northLat = center.getLatitudeE6() * 2 - south.getLatitudeE6();
        points.add(new GeoPoint(south.getLatitudeE6(), east.getLongitudeE6()));
        points.add(new GeoPoint(south.getLatitudeE6(), westLon));
        points.add(new GeoPoint(northLat, westLon));
        points.add(new GeoPoint(northLat, east.getLongitudeE6()));
        return points;
    }

    @Override
    protected void draw(Canvas canvas, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        Projection pj = mapView.getProjection();
        this.mPath.rewind();
        this.mOutline.buildPathPortion(pj);
        for (LinearRing hole : this.mHoles) {
            hole.buildPathPortion(pj);
        }
        canvas.drawPath(this.mPath, this.mFillPaint);
        canvas.drawPath(this.mPath, this.mOutlinePaint);
    }

    public boolean contains(MotionEvent event) {
        if (this.mPath.isEmpty()) {
            return false;
        }
        RectF bounds = new RectF();
        this.mPath.computeBounds(bounds, true);
        Region region = new Region();
        region.setPath(this.mPath, new Region((int)bounds.left, (int)bounds.top, (int)bounds.right, (int)bounds.bottom));
        return region.contains((int)event.getX(), (int)event.getY());
    }

    @Override
    public boolean onSingleTapConfirmed(MotionEvent event, MapView mapView) {
        if (this.mInfoWindow == null) {
            return false;
        }
        boolean tapped = this.contains(event);
        if (tapped) {
            Projection pj = mapView.getProjection();
            GeoPoint position = (GeoPoint)pj.fromPixels((int)event.getX(), (int)event.getY());
            this.mInfoWindow.open(this, position, 0, 0);
        }
        return tapped;
    }

    class LinearRing {
        int[][] mOriginalPoints = new int[0][2];
        ArrayList<Point> mConvertedPoints = new ArrayList(0);
        boolean mPrecomputed = false;

        LinearRing() {
        }

        ArrayList<GeoPoint> getPoints() {
            int size = this.mOriginalPoints.length;
            ArrayList<GeoPoint> result = new ArrayList<GeoPoint>(size);
            for (int i = 0; i < size; ++i) {
                GeoPoint gp = new GeoPoint(this.mOriginalPoints[i][0], this.mOriginalPoints[i][1]);
                result.add(gp);
            }
            return result;
        }

        void setPoints(List<GeoPoint> points) {
            int size = points.size();
            this.mOriginalPoints = new int[size][2];
            this.mConvertedPoints = new ArrayList(size);
            int i = 0;
            for (GeoPoint p : points) {
                this.mOriginalPoints[i][0] = p.getLatitudeE6();
                this.mOriginalPoints[i][1] = p.getLongitudeE6();
                this.mConvertedPoints.add(new Point(p.getLatitudeE6(), p.getLongitudeE6()));
                ++i;
            }
            this.mPrecomputed = false;
        }

        protected void buildPathPortion(Projection pj) {
            int size = this.mConvertedPoints.size();
            if (size < 2) {
                return;
            }
            if (!this.mPrecomputed) {
                for (int i = 0; i < size; ++i) {
                    Point pt = this.mConvertedPoints.get(i);
                    pj.toProjectedPixels(pt.x, pt.y, pt);
                }
                this.mPrecomputed = true;
            }
            Point projectedPoint0 = this.mConvertedPoints.get(0);
            Point screenPoint0 = pj.toPixelsFromProjected(projectedPoint0, Polygon.this.mTempPoint1);
            Polygon.this.mPath.moveTo((float)screenPoint0.x, (float)screenPoint0.y);
            for (int i = 0; i < size; ++i) {
                Point projectedPoint1 = this.mConvertedPoints.get(i);
                Point screenPoint1 = pj.toPixelsFromProjected(projectedPoint1, Polygon.this.mTempPoint2);
                if (Math.abs(screenPoint1.x - screenPoint0.x) + Math.abs(screenPoint1.y - screenPoint0.y) <= 1) continue;
                Polygon.this.mPath.lineTo((float)screenPoint1.x, (float)screenPoint1.y);
                projectedPoint0 = projectedPoint1;
                screenPoint0.x = screenPoint1.x;
                screenPoint0.y = screenPoint1.y;
            }
            Polygon.this.mPath.close();
        }
    }
}

