/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PorterDuff;
import android.os.Build;
import org.osmdroid.ResourceProxy;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Overlay;

public abstract class NonAcceleratedOverlay
extends Overlay {
    private Bitmap mBackingBitmap;
    private Canvas mBackingCanvas;
    private final Matrix mBackingMatrix = new Matrix();
    private final Matrix mCanvasIdentityMatrix = new Matrix();

    protected abstract void onDraw(Canvas var1, MapView var2, boolean var3);

    public NonAcceleratedOverlay(Context ctx) {
        super(ctx);
    }

    public NonAcceleratedOverlay(ResourceProxy pResourceProxy) {
        super(pResourceProxy);
    }

    protected void onDraw(Canvas c, Canvas acceleratedCanvas, MapView osmv, boolean shadow) {
        this.onDraw(c, osmv, shadow);
    }

    public boolean isUsingBackingBitmap() {
        return true;
    }

    @Override
    protected final void draw(Canvas c, MapView osmv, boolean shadow) {
        boolean atLeastHoneycomb;
        boolean bl = atLeastHoneycomb = Build.VERSION.SDK_INT >= 11;
        if (this.isUsingBackingBitmap() && atLeastHoneycomb && c.isHardwareAccelerated()) {
            if (shadow) {
                return;
            }
            if (this.mBackingBitmap == null || this.mBackingBitmap.getWidth() != c.getWidth() || this.mBackingBitmap.getHeight() != c.getHeight()) {
                this.mBackingBitmap = Bitmap.createBitmap((int)c.getWidth(), (int)c.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.mBackingCanvas = new Canvas(this.mBackingBitmap);
            }
            this.mBackingCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
            c.getMatrix(this.mBackingMatrix);
            this.mBackingCanvas.setMatrix(this.mBackingMatrix);
            this.onDraw(this.mBackingCanvas, c, osmv, shadow);
            c.save();
            c.getMatrix(this.mCanvasIdentityMatrix);
            this.mCanvasIdentityMatrix.invert(this.mCanvasIdentityMatrix);
            c.concat(this.mCanvasIdentityMatrix);
            c.drawBitmap(this.mBackingBitmap, 0.0f, 0.0f, null);
            c.restore();
        } else {
            this.onDraw(c, c, osmv, shadow);
        }
    }
}

