/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import java.util.LinkedList;
import org.osmdroid.tileprovider.ReusableBitmapDrawable;

public class BitmapPool {
    final LinkedList<Bitmap> mPool = new LinkedList();
    private static BitmapPool sInstance;

    public static BitmapPool getInstance() {
        if (sInstance == null) {
            sInstance = new BitmapPool();
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnDrawableToPool(ReusableBitmapDrawable drawable) {
        Bitmap b = drawable.tryRecycle();
        if (b != null && b.isMutable()) {
            LinkedList<Bitmap> linkedList = this.mPool;
            synchronized (linkedList) {
                this.mPool.addLast(b);
            }
        }
    }

    public void applyReusableOptions(BitmapFactory.Options bitmapOptions) {
        if (Build.VERSION.SDK_INT >= 11) {
            Bitmap pooledBitmap;
            bitmapOptions.inBitmap = pooledBitmap = this.obtainBitmapFromPool();
            bitmapOptions.inSampleSize = 1;
            bitmapOptions.inMutable = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap obtainBitmapFromPool() {
        Bitmap b;
        LinkedList<Bitmap> linkedList = this.mPool;
        synchronized (linkedList) {
            if (this.mPool.size() == 0) {
                return null;
            }
            b = this.mPool.removeFirst();
        }
        return b;
    }
}

