/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import org.osmdroid.ResourceProxy;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.safecanvas.ISafeCanvas;
import org.osmdroid.views.safecanvas.SafeTranslatedCanvas;

public abstract class SafeDrawOverlay
extends Overlay {
    private static final SafeTranslatedCanvas sSafeCanvas = new SafeTranslatedCanvas();
    private static final Matrix sMatrix = new Matrix();
    private static final float[] sMatrixValues = new float[9];
    private boolean mUseSafeCanvas = true;

    protected abstract void drawSafe(ISafeCanvas var1, MapView var2, boolean var3);

    public SafeDrawOverlay(Context ctx) {
        super(ctx);
    }

    public SafeDrawOverlay(ResourceProxy pResourceProxy) {
        super(pResourceProxy);
    }

    @Override
    protected void draw(Canvas c, MapView osmv, boolean shadow) {
        sSafeCanvas.setCanvas(c);
        if (this.isUsingSafeCanvas()) {
            Rect screenRect = osmv.getProjection().getScreenRect();
            SafeDrawOverlay.sSafeCanvas.xOffset = -screenRect.left;
            SafeDrawOverlay.sSafeCanvas.yOffset = -screenRect.top;
            c.save();
            c.getMatrix(sMatrix);
            sMatrix.getValues(sMatrixValues);
            double angrad = Math.atan2(sMatrixValues[3], sMatrixValues[0]);
            sMatrix.preRotate((float)(-Math.toDegrees(angrad)), (float)screenRect.centerX(), (float)screenRect.centerY());
            sMatrix.getValues(sMatrixValues);
            sMatrix.postTranslate((float)screenRect.left * sMatrixValues[0], (float)screenRect.top * sMatrixValues[4]);
            sMatrix.preRotate((float)Math.toDegrees(angrad), (float)(screenRect.width() / 2), (float)(screenRect.height() / 2));
            c.setMatrix(sMatrix);
        } else {
            SafeDrawOverlay.sSafeCanvas.xOffset = 0;
            SafeDrawOverlay.sSafeCanvas.yOffset = 0;
        }
        this.drawSafe(sSafeCanvas, osmv, shadow);
        if (this.isUsingSafeCanvas()) {
            c.restore();
        }
    }

    public boolean isUsingSafeCanvas() {
        return this.mUseSafeCanvas;
    }

    public void setUseSafeCanvas(boolean useSafeCanvas) {
        this.mUseSafeCanvas = useSafeCanvas;
    }
}

