/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views;

import android.graphics.Point;
import microsoft.mappoint.TileSystem;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.api.IMapController;
import org.osmdroid.util.BoundingBoxE6;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.util.MyMath;
import org.osmdroid.views.util.constants.MapViewConstants;
import org.osmdroid.views.util.constants.MathConstants;

public class MapController
implements IMapController,
MapViewConstants {
    private final MapView mOsmv;
    private AbstractAnimationRunner mCurrentAnimationRunner;

    public MapController(MapView osmv) {
        this.mOsmv = osmv;
    }

    public void zoomToSpan(BoundingBoxE6 bb) {
        this.zoomToSpan(bb.getLatitudeSpanE6(), bb.getLongitudeSpanE6());
    }

    @Override
    public void zoomToSpan(int reqLatSpan, int reqLonSpan) {
        int curLonSpan;
        float diffNeededLon;
        if (reqLatSpan <= 0 || reqLonSpan <= 0) {
            return;
        }
        BoundingBoxE6 bb = this.mOsmv.getBoundingBox();
        int curZoomLevel = this.mOsmv.getZoomLevel();
        int curLatSpan = bb.getLatitudeSpanE6();
        float diffNeededLat = (float)reqLatSpan / (float)curLatSpan;
        float diffNeeded = Math.max(diffNeededLat, diffNeededLon = (float)reqLonSpan / (float)(curLonSpan = bb.getLongitudeSpanE6()));
        if (diffNeeded > 1.0f) {
            this.mOsmv.setZoomLevel(curZoomLevel - MyMath.getNextSquareNumberAbove(diffNeeded));
        } else if ((double)diffNeeded < 0.5) {
            this.mOsmv.setZoomLevel(curZoomLevel + MyMath.getNextSquareNumberAbove(1.0f / diffNeeded) - 1);
        }
    }

    @Override
    public void animateTo(IGeoPoint point) {
        this.animateTo((double)point.getLatitudeE6() / 1000000.0, (double)point.getLongitudeE6() / 1000000.0);
    }

    public void animateTo(double latitude, double longitude) {
        int x = this.mOsmv.getScrollX();
        int y = this.mOsmv.getScrollY();
        Point p = TileSystem.LatLongToPixelXY(latitude, longitude, this.mOsmv.getZoomLevel(), null);
        int worldSize_2 = TileSystem.MapSize(this.mOsmv.getZoomLevel()) / 2;
        this.mOsmv.getScroller().startScroll(x, y, p.x - worldSize_2 - x, p.y - worldSize_2 - y, 1000);
        this.mOsmv.postInvalidate();
    }

    public void animateTo(GeoPoint gp, AnimationType aAnimationType) {
        this.animateTo(gp.getLatitudeE6(), gp.getLongitudeE6(), aAnimationType, 1000, 10);
    }

    public void animateTo(GeoPoint gp, AnimationType aAnimationType, int aSmoothness, int aDuration) {
        this.animateTo(gp.getLatitudeE6(), gp.getLongitudeE6(), aAnimationType, aSmoothness, aDuration);
    }

    public void animateTo(int aLatitudeE6, int aLongitudeE6, AnimationType aAnimationType) {
        this.animateTo(aLatitudeE6, aLongitudeE6, aAnimationType, 10, 1000);
    }

    public void animateTo(int aLatitudeE6, int aLongitudeE6, AnimationType aAnimationType, int aSmoothness, int aDuration) {
        this.stopAnimation(false);
        switch (aAnimationType) {
            case LINEAR: {
                this.mCurrentAnimationRunner = new LinearAnimationRunner(aLatitudeE6, aLongitudeE6, aSmoothness, aDuration);
                break;
            }
            case EXPONENTIALDECELERATING: {
                this.mCurrentAnimationRunner = new ExponentialDeceleratingAnimationRunner(aLatitudeE6, aLongitudeE6, aSmoothness, aDuration);
                break;
            }
            case QUARTERCOSINUSALDECELERATING: {
                this.mCurrentAnimationRunner = new QuarterCosinusalDeceleratingAnimationRunner(aLatitudeE6, aLongitudeE6, aSmoothness, aDuration);
                break;
            }
            case HALFCOSINUSALDECELERATING: {
                this.mCurrentAnimationRunner = new HalfCosinusalDeceleratingAnimationRunner(aLatitudeE6, aLongitudeE6, aSmoothness, aDuration);
                break;
            }
            case MIDDLEPEAKSPEED: {
                this.mCurrentAnimationRunner = new MiddlePeakSpeedAnimationRunner(aLatitudeE6, aLongitudeE6, aSmoothness, aDuration);
            }
        }
        this.mCurrentAnimationRunner.start();
    }

    public void scrollBy(int x, int y) {
        this.mOsmv.scrollBy(x, y);
    }

    @Override
    public void setCenter(IGeoPoint point) {
        Point p = TileSystem.LatLongToPixelXY((double)point.getLatitudeE6() / 1000000.0, (double)point.getLongitudeE6() / 1000000.0, this.mOsmv.getZoomLevel(), null);
        int worldSize_2 = TileSystem.MapSize(this.mOsmv.getZoomLevel()) / 2;
        this.mOsmv.scrollTo(p.x - worldSize_2, p.y - worldSize_2);
    }

    public void stopAnimation(boolean jumpToTarget) {
        AbstractAnimationRunner currentAnimationRunner = this.mCurrentAnimationRunner;
        if (currentAnimationRunner != null && !currentAnimationRunner.isDone()) {
            currentAnimationRunner.interrupt();
            if (jumpToTarget) {
                this.setCenter(new GeoPoint(currentAnimationRunner.mTargetLatitudeE6, currentAnimationRunner.mTargetLongitudeE6));
            }
        }
    }

    @Override
    public int setZoom(int zoomlevel) {
        return this.mOsmv.setZoomLevel(zoomlevel);
    }

    @Override
    public boolean zoomIn() {
        return this.mOsmv.zoomIn();
    }

    public boolean zoomInFixing(GeoPoint point) {
        return this.mOsmv.zoomInFixing(point);
    }

    @Override
    public boolean zoomInFixing(int xPixel, int yPixel) {
        return this.mOsmv.zoomInFixing(xPixel, yPixel);
    }

    @Override
    public boolean zoomOut() {
        return this.mOsmv.zoomOut();
    }

    public boolean zoomOutFixing(GeoPoint point) {
        return this.mOsmv.zoomOutFixing(point);
    }

    @Override
    public boolean zoomOutFixing(int xPixel, int yPixel) {
        return this.mOsmv.zoomOutFixing(xPixel, yPixel);
    }

    protected class MiddlePeakSpeedAnimationRunner
    extends CosinusalBasedAnimationRunner
    implements MathConstants {
        protected MiddlePeakSpeedAnimationRunner(int aTargetLatitudeE6, int aTargetLongitudeE6) {
            this(aTargetLatitudeE6, aTargetLongitudeE6, 10, 1000);
        }

        protected MiddlePeakSpeedAnimationRunner(int aTargetLatitudeE6, int aTargetLongitudeE6, int aSmoothness, int aDuration) {
            super(aTargetLatitudeE6, aTargetLongitudeE6, aSmoothness, aDuration, -1.5707964f, (float)Math.PI, 0.0f);
        }
    }

    protected class HalfCosinusalDeceleratingAnimationRunner
    extends CosinusalBasedAnimationRunner
    implements MathConstants {
        protected HalfCosinusalDeceleratingAnimationRunner(int aTargetLatitudeE6, int aTargetLongitudeE6) {
            this(aTargetLatitudeE6, aTargetLongitudeE6, 10, 1000);
        }

        protected HalfCosinusalDeceleratingAnimationRunner(int aTargetLatitudeE6, int aTargetLongitudeE6, int aSmoothness, int aDuration) {
            super(aTargetLatitudeE6, aTargetLongitudeE6, aSmoothness, aDuration, 0.0f, (float)Math.PI, 1.0f);
        }
    }

    protected class QuarterCosinusalDeceleratingAnimationRunner
    extends CosinusalBasedAnimationRunner
    implements MathConstants {
        protected QuarterCosinusalDeceleratingAnimationRunner(int aTargetLatitudeE6, int aTargetLongitudeE6) {
            this(aTargetLatitudeE6, aTargetLongitudeE6, 10, 1000);
        }

        protected QuarterCosinusalDeceleratingAnimationRunner(int aTargetLatitudeE6, int aTargetLongitudeE6, int aSmoothness, int aDuration) {
            super(aTargetLatitudeE6, aTargetLongitudeE6, aSmoothness, aDuration, 0.0f, 1.5707964f, 0.0f);
        }
    }

    private class CosinusalBasedAnimationRunner
    extends AbstractAnimationRunner
    implements MathConstants {
        protected final float mStepIncrement;
        protected final float mAmountStretch;
        protected final float mYOffset;
        protected final float mStart;

        public CosinusalBasedAnimationRunner(int aTargetLatitudeE6, int aTargetLongitudeE6, float aStart, float aRange, float aYOffset) {
            this(aTargetLatitudeE6, aTargetLongitudeE6, 10, 1000, aStart, aRange, aYOffset);
        }

        public CosinusalBasedAnimationRunner(int aTargetLatitudeE6, int aTargetLongitudeE6, int aSmoothness, int aDuration, float aStart, float aRange, float aYOffset) {
            super(aTargetLatitudeE6, aTargetLongitudeE6, aSmoothness, aDuration);
            this.mYOffset = aYOffset;
            this.mStart = aStart;
            this.mStepIncrement = aRange / (float)aSmoothness;
            float amountSum = 0.0f;
            for (int i = 0; i < aSmoothness; ++i) {
                amountSum = (float)((double)amountSum + ((double)aYOffset + Math.cos(this.mStepIncrement * (float)i + aStart)));
            }
            this.mAmountStretch = 1.0f / amountSum;
            this.setName("QuarterCosinusalDeceleratingAnimationRunner");
        }

        @Override
        public void onRunAnimation() {
            MapView mapview = MapController.this.mOsmv;
            IGeoPoint mapCenter = mapview.getMapCenter();
            int stepDuration = this.mStepDuration;
            float amountStretch = this.mAmountStretch;
            try {
                for (int i = 0; i < this.mSmoothness; ++i) {
                    double delta = ((double)this.mYOffset + Math.cos(this.mStepIncrement * (float)i + this.mStart)) * (double)amountStretch;
                    int deltaLatitudeE6 = (int)((double)this.mPanTotalLatitudeE6 * delta);
                    int deltaLongitudeE6 = (int)((double)this.mPanTotalLongitudeE6 * delta);
                    int newMapCenterLatE6 = mapCenter.getLatitudeE6() - deltaLatitudeE6;
                    int newMapCenterLonE6 = mapCenter.getLongitudeE6() - deltaLongitudeE6;
                    mapview.setMapCenter(newMapCenterLatE6, newMapCenterLonE6);
                    Thread.sleep(stepDuration);
                }
                mapview.setMapCenter(this.mTargetLatitudeE6, this.mTargetLongitudeE6);
            }
            catch (Exception e) {
                this.interrupt();
            }
        }
    }

    private class ExponentialDeceleratingAnimationRunner
    extends AbstractAnimationRunner {
        public ExponentialDeceleratingAnimationRunner(int aTargetLatitudeE6, int aTargetLongitudeE6) {
            this(aTargetLatitudeE6, aTargetLongitudeE6, 10, 1000);
        }

        public ExponentialDeceleratingAnimationRunner(int aTargetLatitudeE6, int aTargetLongitudeE6, int aSmoothness, int aDuration) {
            super(aTargetLatitudeE6, aTargetLongitudeE6, aSmoothness, aDuration);
            this.setName("ExponentialDeceleratingAnimationRunner");
        }

        @Override
        public void onRunAnimation() {
            MapView mapview = MapController.this.mOsmv;
            IGeoPoint mapCenter = mapview.getMapCenter();
            int stepDuration = this.mStepDuration;
            try {
                for (int i = 0; i < this.mSmoothness; ++i) {
                    double delta = Math.pow(0.5, i + 1);
                    int deltaLatitudeE6 = (int)((double)this.mPanTotalLatitudeE6 * delta);
                    int detlaLongitudeE6 = (int)((double)this.mPanTotalLongitudeE6 * delta);
                    int newMapCenterLatE6 = mapCenter.getLatitudeE6() - deltaLatitudeE6;
                    int newMapCenterLonE6 = mapCenter.getLongitudeE6() - detlaLongitudeE6;
                    mapview.setMapCenter(newMapCenterLatE6, newMapCenterLonE6);
                    Thread.sleep(stepDuration);
                }
                mapview.setMapCenter(this.mTargetLatitudeE6, this.mTargetLongitudeE6);
            }
            catch (Exception e) {
                this.interrupt();
            }
        }
    }

    private class LinearAnimationRunner
    extends AbstractAnimationRunner {
        protected final int mPanPerStepLatitudeE6;
        protected final int mPanPerStepLongitudeE6;

        public LinearAnimationRunner(int aTargetLatitudeE6, int aTargetLongitudeE6) {
            this(aTargetLatitudeE6, aTargetLongitudeE6, 10, 1000);
        }

        public LinearAnimationRunner(int aTargetLatitudeE6, int aTargetLongitudeE6, int aSmoothness, int aDuration) {
            super(aTargetLatitudeE6, aTargetLongitudeE6, aSmoothness, aDuration);
            MapView mapview = MapController.this.mOsmv;
            IGeoPoint mapCenter = mapview.getMapCenter();
            this.mPanPerStepLatitudeE6 = (mapCenter.getLatitudeE6() - aTargetLatitudeE6) / aSmoothness;
            this.mPanPerStepLongitudeE6 = (mapCenter.getLongitudeE6() - aTargetLongitudeE6) / aSmoothness;
            this.setName("LinearAnimationRunner");
        }

        @Override
        public void onRunAnimation() {
            MapView mapview = MapController.this.mOsmv;
            IGeoPoint mapCenter = mapview.getMapCenter();
            int panPerStepLatitudeE6 = this.mPanPerStepLatitudeE6;
            int panPerStepLongitudeE6 = this.mPanPerStepLongitudeE6;
            int stepDuration = this.mStepDuration;
            try {
                for (int i = this.mSmoothness; i > 0; --i) {
                    int newMapCenterLatE6 = mapCenter.getLatitudeE6() - panPerStepLatitudeE6;
                    int newMapCenterLonE6 = mapCenter.getLongitudeE6() - panPerStepLongitudeE6;
                    mapview.setMapCenter(newMapCenterLatE6, newMapCenterLonE6);
                    Thread.sleep(stepDuration);
                }
            }
            catch (Exception e) {
                this.interrupt();
            }
        }
    }

    private abstract class AbstractAnimationRunner
    extends Thread {
        protected final int mSmoothness;
        protected final int mTargetLatitudeE6;
        protected final int mTargetLongitudeE6;
        protected boolean mDone = false;
        protected final int mStepDuration;
        protected final int mPanTotalLatitudeE6;
        protected final int mPanTotalLongitudeE6;

        public AbstractAnimationRunner(MapController mapViewController, int aTargetLatitudeE6, int aTargetLongitudeE6) {
            this(aTargetLatitudeE6, aTargetLongitudeE6, 10, 1000);
        }

        public AbstractAnimationRunner(int aTargetLatitudeE6, int aTargetLongitudeE6, int aSmoothness, int aDuration) {
            this.mTargetLatitudeE6 = aTargetLatitudeE6;
            this.mTargetLongitudeE6 = aTargetLongitudeE6;
            this.mSmoothness = aSmoothness;
            this.mStepDuration = aDuration / aSmoothness;
            MapView mapview = MapController.this.mOsmv;
            IGeoPoint mapCenter = mapview.getMapCenter();
            this.mPanTotalLatitudeE6 = mapCenter.getLatitudeE6() - aTargetLatitudeE6;
            this.mPanTotalLongitudeE6 = mapCenter.getLongitudeE6() - aTargetLongitudeE6;
        }

        @Override
        public void run() {
            this.onRunAnimation();
            this.mDone = true;
        }

        public boolean isDone() {
            return this.mDone;
        }

        public abstract void onRunAnimation();
    }

    public static enum AnimationType {
        LINEAR,
        EXPONENTIALDECELERATING,
        QUARTERCOSINUSALDECELERATING,
        HALFCOSINUSALDECELERATING,
        MIDDLEPEAKSPEED;

    }
}

