/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider.modules;

import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.MapTileRequestState;
import org.osmdroid.tileprovider.modules.IFilesystemCache;
import org.osmdroid.tileprovider.modules.INetworkAvailablityCheck;
import org.osmdroid.tileprovider.modules.MapTileModuleProviderBase;
import org.osmdroid.tileprovider.tilesource.BitmapTileSourceBase;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.tileprovider.tilesource.OnlineTileSourceBase;
import org.osmdroid.tileprovider.util.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapTileDownloader
extends MapTileModuleProviderBase {
    private static final Logger logger = LoggerFactory.getLogger(MapTileDownloader.class);
    private final IFilesystemCache mFilesystemCache;
    private OnlineTileSourceBase mTileSource;
    private final INetworkAvailablityCheck mNetworkAvailablityCheck;

    public MapTileDownloader(ITileSource pTileSource) {
        this(pTileSource, null, null);
    }

    public MapTileDownloader(ITileSource pTileSource, IFilesystemCache pFilesystemCache) {
        this(pTileSource, pFilesystemCache, null);
    }

    public MapTileDownloader(ITileSource pTileSource, IFilesystemCache pFilesystemCache, INetworkAvailablityCheck pNetworkAvailablityCheck) {
        super(2, 40);
        this.mFilesystemCache = pFilesystemCache;
        this.mNetworkAvailablityCheck = pNetworkAvailablityCheck;
        this.setTileSource(pTileSource);
    }

    public ITileSource getTileSource() {
        return this.mTileSource;
    }

    @Override
    public boolean getUsesDataConnection() {
        return true;
    }

    @Override
    protected String getName() {
        return "Online Tile Download Provider";
    }

    @Override
    protected String getThreadGroupName() {
        return "downloader";
    }

    @Override
    protected Runnable getTileLoader() {
        return new TileLoader();
    }

    @Override
    public int getMinimumZoomLevel() {
        return this.mTileSource != null ? this.mTileSource.getMinimumZoomLevel() : 0;
    }

    @Override
    public int getMaximumZoomLevel() {
        return this.mTileSource != null ? this.mTileSource.getMaximumZoomLevel() : 22;
    }

    @Override
    public void setTileSource(ITileSource tileSource) {
        this.mTileSource = tileSource instanceof OnlineTileSourceBase ? (OnlineTileSourceBase)tileSource : null;
    }

    private class TileLoader
    extends MapTileModuleProviderBase.TileLoader {
        private TileLoader() {
            super(MapTileDownloader.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Drawable loadTile(MapTileRequestState aState) throws MapTileModuleProviderBase.CantContinueException {
            Drawable drawable;
            BufferedOutputStream out;
            InputStream in;
            block20: {
                Drawable drawable2;
                block19: {
                    if (MapTileDownloader.this.mTileSource == null) {
                        return null;
                    }
                    in = null;
                    out = null;
                    MapTile tile = aState.getMapTile();
                    try {
                        Drawable result;
                        if (MapTileDownloader.this.mNetworkAvailablityCheck != null && !MapTileDownloader.this.mNetworkAvailablityCheck.getNetworkAvailable()) {
                            Drawable drawable3 = null;
                            return drawable3;
                        }
                        String tileURLString = MapTileDownloader.this.mTileSource.getTileURLString(tile);
                        if (TextUtils.isEmpty((CharSequence)tileURLString)) {
                            Drawable drawable4 = null;
                            return drawable4;
                        }
                        DefaultHttpClient client = new DefaultHttpClient();
                        HttpGet head = new HttpGet(tileURLString);
                        HttpResponse response = client.execute((HttpUriRequest)head);
                        HttpEntity entity = response.getEntity();
                        if (entity == null) {
                            logger.warn("No content downloading MapTile: " + tile);
                            drawable2 = null;
                            StreamUtils.closeStream(in);
                            break block19;
                        }
                        in = entity.getContent();
                        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
                        out = new BufferedOutputStream(dataStream, 8192);
                        StreamUtils.copy(in, out);
                        ((OutputStream)out).flush();
                        byte[] data = dataStream.toByteArray();
                        ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
                        if (MapTileDownloader.this.mFilesystemCache != null) {
                            MapTileDownloader.this.mFilesystemCache.saveFile(MapTileDownloader.this.mTileSource, tile, byteStream);
                            byteStream.reset();
                        }
                        drawable = result = MapTileDownloader.this.mTileSource.getDrawable(byteStream);
                        StreamUtils.closeStream(in);
                        break block20;
                    }
                    catch (UnknownHostException e) {
                        logger.warn("UnknownHostException downloading MapTile: " + tile + " : " + e);
                        throw new MapTileModuleProviderBase.CantContinueException((MapTileModuleProviderBase)MapTileDownloader.this, (Throwable)e);
                    }
                    catch (BitmapTileSourceBase.LowMemoryException e) {
                        logger.warn("LowMemoryException downloading MapTile: " + tile + " : " + e);
                        throw new MapTileModuleProviderBase.CantContinueException((MapTileModuleProviderBase)MapTileDownloader.this, (Throwable)e);
                    }
                    catch (FileNotFoundException e) {
                        logger.warn("Tile not found: " + tile + " : " + e);
                        return null;
                    }
                    catch (IOException e) {
                        logger.warn("IOException downloading MapTile: " + tile + " : " + e);
                        return null;
                    }
                    catch (Throwable e) {
                        logger.error("Error downloading MapTile: " + tile, e);
                        return null;
                    }
                }
                StreamUtils.closeStream(out);
                return drawable2;
            }
            StreamUtils.closeStream(out);
            return drawable;
            finally {
                StreamUtils.closeStream(in);
                StreamUtils.closeStream(out);
            }
        }

        @Override
        protected void tileLoaded(MapTileRequestState pState, Drawable pDrawable) {
            MapTileDownloader.this.removeTileFromQueues(pState.getMapTile());
            pState.getCallback().mapTileRequestCompleted(pState, null);
        }
    }
}

