/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.tileprovider;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import java.util.HashMap;
import microsoft.mappoint.TileSystem;
import org.osmdroid.tileprovider.ExpirableBitmapDrawable;
import org.osmdroid.tileprovider.IMapTileProviderCallback;
import org.osmdroid.tileprovider.MapTile;
import org.osmdroid.tileprovider.MapTileCache;
import org.osmdroid.tileprovider.MapTileRequestState;
import org.osmdroid.tileprovider.constants.OpenStreetMapTileProviderConstants;
import org.osmdroid.tileprovider.tilesource.ITileSource;
import org.osmdroid.util.TileLooper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MapTileProviderBase
implements IMapTileProviderCallback,
OpenStreetMapTileProviderConstants {
    private static final Logger logger = LoggerFactory.getLogger(MapTileProviderBase.class);
    protected final MapTileCache mTileCache = new MapTileCache();
    protected Handler mTileRequestCompleteHandler;
    protected boolean mUseDataConnection = true;
    private ITileSource mTileSource;

    public abstract Drawable getMapTile(MapTile var1);

    public abstract void detach();

    public abstract int getMinimumZoomLevel();

    public abstract int getMaximumZoomLevel();

    public void setTileSource(ITileSource pTileSource) {
        this.mTileSource = pTileSource;
        this.clearTileCache();
    }

    public ITileSource getTileSource() {
        return this.mTileSource;
    }

    public MapTileProviderBase(ITileSource pTileSource) {
        this(pTileSource, null);
    }

    public MapTileProviderBase(ITileSource pTileSource, Handler pDownloadFinishedListener) {
        this.mTileRequestCompleteHandler = pDownloadFinishedListener;
        this.mTileSource = pTileSource;
    }

    @Override
    public void mapTileRequestCompleted(MapTileRequestState pState, Drawable pDrawable) {
        MapTile tile = pState.getMapTile();
        if (pDrawable != null) {
            this.mTileCache.putTile(tile, pDrawable);
        }
        if (this.mTileRequestCompleteHandler != null) {
            this.mTileRequestCompleteHandler.sendEmptyMessage(0);
        }
    }

    @Override
    public void mapTileRequestFailed(MapTileRequestState pState) {
        MapTile tile = pState.getMapTile();
        if (this.mTileRequestCompleteHandler != null) {
            this.mTileRequestCompleteHandler.sendEmptyMessage(1);
        }
    }

    public void setTileRequestCompleteHandler(Handler handler) {
        this.mTileRequestCompleteHandler = handler;
    }

    public void ensureCapacity(int pCapacity) {
        this.mTileCache.ensureCapacity(pCapacity);
    }

    public void clearTileCache() {
        this.mTileCache.clear();
    }

    @Override
    public boolean useDataConnection() {
        return this.mUseDataConnection;
    }

    public void setUseDataConnection(boolean pMode) {
        this.mUseDataConnection = pMode;
    }

    public void rescaleCache(int pNewZoomLevel, int pOldZoomLevel, Rect pViewPort) {
        if (pNewZoomLevel == pOldZoomLevel) {
            return;
        }
        long startMs = System.currentTimeMillis();
        logger.info("rescale tile cache from " + pOldZoomLevel + " to " + pNewZoomLevel);
        int tileSize = this.getTileSource().getTileSizePixels();
        int worldSize_2 = TileSystem.MapSize(pNewZoomLevel) >> 1;
        Rect viewPort = new Rect(pViewPort);
        viewPort.offset(worldSize_2, worldSize_2);
        ScaleTileLooper tileLooper = pNewZoomLevel > pOldZoomLevel ? new ZoomInTileLooper(pOldZoomLevel) : new ZoomOutTileLooper(pOldZoomLevel);
        tileLooper.loop(null, pNewZoomLevel, tileSize, viewPort);
        long endMs = System.currentTimeMillis();
        logger.info("Finished rescale in " + (endMs - startMs) + "ms");
    }

    private class ZoomOutTileLooper
    extends ScaleTileLooper {
        public ZoomOutTileLooper(int pOldZoomLevel) {
            super(pOldZoomLevel);
        }

        @Override
        protected void handleTile(int pTileSizePx, MapTile pTile, int pX, int pY) {
            int xx = pTile.getX() << this.mDiff;
            int yy = pTile.getY() << this.mDiff;
            int numTiles = 1 << this.mDiff;
            Bitmap bitmap2 = null;
            Canvas canvas = null;
            for (int x = 0; x < numTiles; ++x) {
                for (int y = 0; y < numTiles; ++y) {
                    Bitmap oldBitmap;
                    MapTile oldTile = new MapTile(this.mOldZoomLevel, xx + x, yy + y);
                    Drawable oldDrawable = MapTileProviderBase.this.mTileCache.getMapTile(oldTile);
                    if (!(oldDrawable instanceof BitmapDrawable) || (oldBitmap = ((BitmapDrawable)oldDrawable).getBitmap()) == null) continue;
                    if (bitmap2 == null) {
                        bitmap2 = Bitmap.createBitmap((int)pTileSizePx, (int)pTileSizePx, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        canvas = new Canvas(bitmap2);
                        canvas.drawColor(-3355444);
                    }
                    this.mDestRect.set(x * this.mTileSize_2, y * this.mTileSize_2, (x + 1) * this.mTileSize_2, (y + 1) * this.mTileSize_2);
                    if (oldBitmap == null) continue;
                    canvas.drawBitmap(oldBitmap, null, this.mDestRect, null);
                    MapTileProviderBase.this.mTileCache.mCachedTiles.remove(oldBitmap);
                }
            }
            if (bitmap2 != null) {
                this.mNewTiles.put(pTile, bitmap2);
            }
        }
    }

    private class ZoomInTileLooper
    extends ScaleTileLooper {
        public ZoomInTileLooper(int pOldZoomLevel) {
            super(pOldZoomLevel);
        }

        @Override
        public void handleTile(int pTileSizePx, MapTile pTile, int pX, int pY) {
            MapTile oldTile = new MapTile(this.mOldZoomLevel, pTile.getX() >> this.mDiff, pTile.getY() >> this.mDiff);
            Drawable oldDrawable = MapTileProviderBase.this.mTileCache.getMapTile(oldTile);
            if (oldDrawable instanceof BitmapDrawable) {
                Bitmap oldBitmap = ((BitmapDrawable)oldDrawable).getBitmap();
                int xx = pX % (1 << this.mDiff) * this.mTileSize_2;
                int yy = pY % (1 << this.mDiff) * this.mTileSize_2;
                this.mSrcRect.set(xx, yy, xx + this.mTileSize_2, yy + this.mTileSize_2);
                this.mDestRect.set(0, 0, pTileSizePx, pTileSizePx);
                Bitmap bitmap2 = Bitmap.createBitmap((int)pTileSizePx, (int)pTileSizePx, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap2);
                canvas.drawBitmap(oldBitmap, this.mSrcRect, this.mDestRect, null);
                this.mNewTiles.put(pTile, bitmap2);
            }
        }
    }

    private abstract class ScaleTileLooper
    extends TileLooper {
        protected final HashMap<MapTile, Bitmap> mNewTiles;
        protected final int mOldZoomLevel;
        protected int mDiff;
        protected int mTileSize_2;
        protected Rect mSrcRect;
        protected Rect mDestRect;
        protected Paint mDebugPaint;

        public ScaleTileLooper(int pOldZoomLevel) {
            this.mOldZoomLevel = pOldZoomLevel;
            this.mNewTiles = new HashMap();
            this.mSrcRect = new Rect();
            this.mDestRect = new Rect();
            this.mDebugPaint = new Paint();
        }

        @Override
        public void initialiseLoop(int pZoomLevel, int pTileSizePx) {
            this.mDiff = Math.abs(pZoomLevel - this.mOldZoomLevel);
            this.mTileSize_2 = pTileSizePx >> this.mDiff;
        }

        @Override
        public void handleTile(Canvas pCanvas, int pTileSizePx, MapTile pTile, int pX, int pY) {
            Drawable requestedTile = MapTileProviderBase.this.getMapTile(pTile);
            if (requestedTile == null) {
                try {
                    this.handleTile(pTileSizePx, pTile, pX, pY);
                }
                catch (OutOfMemoryError e) {
                    logger.error("OutOfMemoryError rescaling cache");
                }
            }
        }

        @Override
        public void finaliseLoop() {
            while (!this.mNewTiles.isEmpty()) {
                MapTile tile = this.mNewTiles.keySet().iterator().next();
                Bitmap bitmap2 = this.mNewTiles.remove(tile);
                MapTileProviderBase.this.mTileCache.putTile(tile, (Drawable)new ExpirableBitmapDrawable(bitmap2));
            }
        }

        protected abstract void handleTile(int var1, MapTile var2, int var3, int var4);
    }
}

