/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.safecanvas;

import android.graphics.Path;
import android.graphics.PathDashPathEffect;

public class SafeDashPathEffect
extends PathDashPathEffect {
    public SafeDashPathEffect(float[] intervals, float phase, float strokeWidth) {
        super(SafeDashPathEffect.createSafeDashedPath(intervals, phase, strokeWidth, null), SafeDashPathEffect.floatSum(intervals), phase, PathDashPathEffect.Style.MORPH);
    }

    public static Path createSafeDashedPath(float[] intervals, float phase, float strokeWidth, Path reuse) {
        if (reuse == null) {
            reuse = new Path();
        }
        reuse.reset();
        reuse.moveTo(0.0f, 0.0f);
        for (int a = 0; a < intervals.length; ++a) {
            if (a % 2 == 0) {
                reuse.rMoveTo(0.0f, strokeWidth / 2.0f);
                reuse.rLineTo(intervals[a], 0.0f);
                reuse.rLineTo(0.0f, -strokeWidth);
                reuse.rLineTo(-intervals[a], 0.0f);
                reuse.rLineTo(0.0f, strokeWidth / 2.0f);
                reuse.rMoveTo(intervals[a], 0.0f);
                continue;
            }
            reuse.rMoveTo(intervals[a], 0.0f);
        }
        return reuse;
    }

    private static float floatSum(float[] array) {
        float result = 0.0f;
        for (int a = 0; a < array.length; ++a) {
            result += array[a];
        }
        return result;
    }
}

