/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay.compass;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import org.osmdroid.views.overlay.compass.IOrientationConsumer;
import org.osmdroid.views.overlay.compass.IOrientationProvider;

public class InternalCompassOrientationProvider
implements SensorEventListener,
IOrientationProvider {
    private IOrientationConsumer mOrientationConsumer;
    private final SensorManager mSensorManager;
    private float mAzimuth;

    public InternalCompassOrientationProvider(Context context) {
        this.mSensorManager = (SensorManager)context.getSystemService("sensor");
    }

    @Override
    public boolean startOrientationProvider(IOrientationConsumer orientationConsumer) {
        this.mOrientationConsumer = orientationConsumer;
        boolean result = false;
        Sensor sensor = this.mSensorManager.getDefaultSensor(3);
        if (sensor != null) {
            result = this.mSensorManager.registerListener((SensorEventListener)this, sensor, 2);
        }
        return result;
    }

    @Override
    public void stopOrientationProvider() {
        this.mSensorManager.unregisterListener((SensorEventListener)this);
    }

    @Override
    public float getLastKnownOrientation() {
        return this.mAzimuth;
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor.getType() == 3 && event.values != null) {
            this.mAzimuth = event.values[0];
            if (this.mOrientationConsumer != null) {
                this.mOrientationConsumer.onOrientationChanged(this.mAzimuth, this);
            }
        }
    }
}

