/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.views.overlay;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.os.Build;
import org.osmdroid.ResourceProxy;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.safecanvas.ISafeCanvas;
import org.osmdroid.views.safecanvas.SafeTranslatedCanvas;

public abstract class SafeDrawOverlay
extends Overlay {
    private static final SafeTranslatedCanvas sSafeCanvas = new SafeTranslatedCanvas();
    private static final Matrix sMatrix = new Matrix();
    private static final float[] sMatrixValues = new float[9];
    private boolean mUseSafeCanvas = true;

    protected abstract void drawSafe(ISafeCanvas var1, MapView var2, boolean var3);

    public SafeDrawOverlay(Context ctx) {
        super(ctx);
    }

    public SafeDrawOverlay(ResourceProxy pResourceProxy) {
        super(pResourceProxy);
    }

    @Override
    protected void draw(Canvas c, MapView osmv, boolean shadow) {
        sSafeCanvas.setCanvas(c);
        if (this.isUsingSafeCanvas()) {
            Rect screenRect = osmv.getProjection().getScreenRect();
            SafeDrawOverlay.sSafeCanvas.xOffset = -screenRect.left;
            SafeDrawOverlay.sSafeCanvas.yOffset = -screenRect.top;
            c.save();
            if (Build.VERSION.SDK_INT >= 11) {
                float scaleX = osmv.getScaleX();
                float scaleY = osmv.getScaleY();
                c.translate((float)screenRect.left * scaleX, (float)screenRect.top * scaleY);
            } else {
                c.getMatrix(sMatrix);
                sMatrix.preTranslate((float)screenRect.left, (float)screenRect.top);
                c.setMatrix(sMatrix);
            }
        } else {
            SafeDrawOverlay.sSafeCanvas.xOffset = 0;
            SafeDrawOverlay.sSafeCanvas.yOffset = 0;
        }
        this.drawSafe(sSafeCanvas, osmv, shadow);
        if (this.isUsingSafeCanvas()) {
            c.restore();
        }
    }

    public boolean isUsingSafeCanvas() {
        return this.mUseSafeCanvas;
    }

    public void setUseSafeCanvas(boolean useSafeCanvas) {
        this.mUseSafeCanvas = useSafeCanvas;
    }
}

