/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.spi.support;

import org.osgi.framework.ServiceReference;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class FormattingTriple {
    private final FormattingTuple argsAndThrowable;
    private ServiceReference<?> serviceReference;

    private FormattingTriple(String message, Object[] argArray, Throwable throwable, ServiceReference<?> reference) {
        this.argsAndThrowable = new FormattingTuple(message, argArray, throwable);
        this.serviceReference = reference;
    }

    public static FormattingTriple discover(String format, boolean printfFormatting, Object ... argArray) {
        return FormattingTriple.forArguments(format, printfFormatting, false, argArray);
    }

    public static FormattingTriple resolve(String format, boolean printfFormatting, Object ... argArray) {
        return FormattingTriple.forArguments(format, printfFormatting, true, argArray);
    }

    private static FormattingTriple forArguments(String format, boolean printfFormatting, boolean resolve, Object ... argArray) {
        if (argArray == null || argArray.length == 0) {
            return new FormattingTriple(format, null, null, null);
        }
        if (argArray.length == 1) {
            if (argArray[0] != null && Throwable.class.isAssignableFrom(argArray[0].getClass())) {
                return new FormattingTriple(format, null, (Throwable)argArray[0], null);
            }
            if (argArray[0] != null && ServiceReference.class.isAssignableFrom(argArray[0].getClass())) {
                return new FormattingTriple(format, null, null, (ServiceReference)argArray[0]);
            }
            if (printfFormatting) {
                String m = String.format(format, argArray);
                return new FormattingTriple(m, argArray, null, null);
            }
            String m = MessageFormatter.arrayFormat(format, argArray, null).getMessage();
            return new FormattingTriple(m, argArray, null, null);
        }
        int i1 = argArray.length - 1;
        int i2 = argArray.length - 2;
        Throwable t = null;
        ServiceReference sr = null;
        if (argArray[i1] != null) {
            if (Throwable.class.isAssignableFrom(argArray[i1].getClass())) {
                t = (Throwable)argArray[i1];
            } else if (ServiceReference.class.isAssignableFrom(argArray[i1].getClass())) {
                sr = (ServiceReference)argArray[i1];
            }
        }
        if (argArray[i2] != null && (t != null || sr != null)) {
            if (sr != null && Throwable.class.isAssignableFrom(argArray[i2].getClass())) {
                t = (Throwable)argArray[i2];
            } else if (t != null && ServiceReference.class.isAssignableFrom(argArray[i2].getClass())) {
                sr = (ServiceReference)argArray[i2];
            }
        }
        int toCopy = argArray.length;
        if (t != null) {
            --toCopy;
        }
        if (sr != null) {
            --toCopy;
        }
        Object[] newArgs = new Object[toCopy];
        System.arraycopy(argArray, 0, newArgs, 0, toCopy);
        if (printfFormatting) {
            String m = resolve ? String.format(format, newArgs) : format;
            return new FormattingTriple(m, newArgs, t, sr);
        }
        String m = resolve ? MessageFormatter.arrayFormat(format, newArgs, t).getMessage() : format;
        return new FormattingTriple(m, newArgs, t, sr);
    }

    public String getMessage() {
        return this.argsAndThrowable.getMessage();
    }

    public Object[] getArgArray() {
        return this.argsAndThrowable.getArgArray();
    }

    public Throwable getThrowable() {
        return this.argsAndThrowable.getThrowable();
    }

    public ServiceReference<?> getServiceReference() {
        return this.serviceReference;
    }
}

