/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcengine.jvm;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ConvertingInputStream
extends InputStream {
    private DataInputStream in;
    private byte[] buffer = new byte[0];
    private int pos;
    private boolean end = false;

    public ConvertingInputStream(DataInputStream in) {
        this.in = in;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.end) {
            int min = Math.min(this.buffer.length - this.pos, len);
            if (min == 0) {
                return -1;
            }
            System.arraycopy(this.buffer, this.pos, b, off, min);
            return min;
        }
        while (this.buffer.length - this.pos < len) {
            int size = this.in.readInt();
            if (size == -1) {
                this.end = true;
                int min = Math.min(this.buffer.length - this.pos, len);
                System.arraycopy(this.buffer, this.pos, b, off, min);
                this.pos += min;
                return min;
            }
            byte[] tmp = this.buffer;
            this.buffer = new byte[this.buffer.length + size];
            System.arraycopy(tmp, 0, this.buffer, 0, tmp.length);
            this.in.readFully(this.buffer, tmp.length, size);
        }
        System.arraycopy(this.buffer, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public int read() throws IOException {
        return 0;
    }
}

