/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcengine;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.ifcengine.JvmIfcEngine;
import org.bimserver.models.store.ObjectDefinition;
import org.bimserver.plugins.Dependency;
import org.bimserver.plugins.Plugin;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.PluginContext;
import org.bimserver.plugins.PluginManagerInterface;
import org.bimserver.plugins.renderengine.RenderEngine;
import org.bimserver.plugins.renderengine.RenderEngineException;
import org.bimserver.plugins.renderengine.RenderEnginePlugin;
import org.bimserver.shared.exceptions.PluginException;
import org.bimserver.utils.PathUtils;

public class JvmRenderEnginePlugin
implements RenderEnginePlugin {
    private PluginManagerInterface pluginManager;
    private Path nativeFolder;
    private Path schemaFile;
    private PluginContext pluginContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(PluginManagerInterface pluginManager) throws PluginException {
        block16: {
            this.pluginManager = pluginManager;
            try {
                this.pluginContext = pluginManager.getPluginContext((Plugin)this);
                String os = System.getProperty("os.name").toLowerCase();
                String libraryName = "";
                if (os.contains("windows")) {
                    libraryName = "ifcengine.dll";
                } else if (os.contains("osx") || os.contains("os x") || os.contains("darwin")) {
                    libraryName = "libIFCEngine.dylib";
                } else if (os.contains("linux")) {
                    libraryName = "libifcengine.so";
                }
                InputStream inputStream = Files.newInputStream(this.pluginContext.getRootPath().resolve("lib/" + System.getProperty("sun.arch.data.model") + "/" + libraryName), new OpenOption[0]);
                if (inputStream == null) break block16;
                try {
                    Path tmpFolder = pluginManager.getTempDir();
                    this.nativeFolder = tmpFolder.resolve("ifcenginedll");
                    Path file = this.nativeFolder.resolve(libraryName);
                    if (Files.exists(this.nativeFolder, new LinkOption[0])) {
                        try {
                            PathUtils.removeDirectoryWithContent((Path)this.nativeFolder);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    Files.createDirectories(this.nativeFolder, new FileAttribute[0]);
                    try (OutputStream outputStream = Files.newOutputStream(file, new OpenOption[0]);){
                        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                    }
                }
                finally {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                throw new PluginException((Throwable)e);
            }
        }
    }

    public RenderEngine createRenderEngine(PluginConfiguration pluginConfiguration, String schema) throws RenderEngineException {
        try {
            PackageMetaData packageMetaData = this.pluginManager.getMetaDataManager().getPackageMetaData(schema);
            this.schemaFile = packageMetaData.getSchemaPath();
            if (this.schemaFile == null) {
                throw new RenderEngineException("No schema file");
            }
            ArrayList<String> classPathEntries = new ArrayList<String>();
            for (Dependency dependency : this.pluginContext.getDependencies()) {
                Path path = dependency.getPath();
                classPathEntries.add(path.toAbsolutePath().toString());
            }
            this.pluginContext.getClassLocation();
            return new JvmIfcEngine(this.schemaFile, this.nativeFolder, this.pluginManager.getTempDir(), this.pluginContext.getClassLocation(), classPathEntries);
        }
        catch (PluginException e) {
            throw new RenderEngineException((Exception)((Object)e));
        }
    }

    public String getDefaultName() {
        return "IFC Engine DLL";
    }

    public ObjectDefinition getSettingsDefinition() {
        return null;
    }
}

