/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcengine;

import org.bimserver.ifcengine.Command;
import org.bimserver.ifcengine.JvmIfcEngine;
import org.bimserver.plugins.renderengine.RenderEngineException;
import org.bimserver.plugins.renderengine.RenderEngineGeometry;
import org.bimserver.plugins.renderengine.RenderEngineInstance;
import org.bimserver.plugins.renderengine.RenderEngineSurfaceProperties;

public class JvmIfcEngineInstance
implements RenderEngineInstance {
    private final JvmIfcEngine failSafeIfcEngine;
    private final int instanceId;
    private final int modelId;

    public JvmIfcEngineInstance(JvmIfcEngine failSafeIfcEngine, int modelId, int instanceId) {
        this.failSafeIfcEngine = failSafeIfcEngine;
        this.modelId = modelId;
        this.instanceId = instanceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getTransformationMatrix() throws RenderEngineException {
        JvmIfcEngine jvmIfcEngine = this.failSafeIfcEngine;
        synchronized (jvmIfcEngine) {
            this.failSafeIfcEngine.writeCommand(Command.GET_TRANSFORMATION_MATRIX);
            this.failSafeIfcEngine.writeInt(this.modelId);
            this.failSafeIfcEngine.writeInt(this.instanceId);
            this.failSafeIfcEngine.flush();
            double[] result = new double[16];
            for (int i = 0; i < 16; ++i) {
                result[i] = this.failSafeIfcEngine.readDouble();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getArea() throws RenderEngineException {
        JvmIfcEngine jvmIfcEngine = this.failSafeIfcEngine;
        synchronized (jvmIfcEngine) {
            this.failSafeIfcEngine.writeCommand(Command.GET_AREA);
            this.failSafeIfcEngine.writeInt(this.modelId);
            this.failSafeIfcEngine.writeInt(this.instanceId);
            this.failSafeIfcEngine.flush();
            return this.failSafeIfcEngine.readDouble();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getVolume() throws RenderEngineException {
        JvmIfcEngine jvmIfcEngine = this.failSafeIfcEngine;
        synchronized (jvmIfcEngine) {
            this.failSafeIfcEngine.writeCommand(Command.GET_VOLUME);
            this.failSafeIfcEngine.writeInt(this.modelId);
            this.failSafeIfcEngine.writeInt(this.instanceId);
            this.failSafeIfcEngine.flush();
            return this.failSafeIfcEngine.readDouble();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RenderEngineSurfaceProperties initialize() throws RenderEngineException {
        JvmIfcEngine jvmIfcEngine = this.failSafeIfcEngine;
        synchronized (jvmIfcEngine) {
            this.failSafeIfcEngine.writeCommand(Command.INITIALIZE_MODELLING_INSTANCE);
            this.failSafeIfcEngine.writeInt(this.modelId);
            this.failSafeIfcEngine.writeInt(this.instanceId);
            this.failSafeIfcEngine.flush();
            int noIndices = this.failSafeIfcEngine.readInt();
            int noVertices = this.failSafeIfcEngine.readInt();
            return new RenderEngineSurfaceProperties(this.modelId, noVertices, noIndices, 0.0);
        }
    }

    public RenderEngineGeometry generateGeometry() throws RenderEngineException {
        RenderEngineSurfaceProperties initialize = this.initialize();
        return this.finalize(initialize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RenderEngineGeometry finalize(RenderEngineSurfaceProperties initialize) throws RenderEngineException {
        JvmIfcEngine jvmIfcEngine = this.failSafeIfcEngine;
        synchronized (jvmIfcEngine) {
            int i;
            this.failSafeIfcEngine.writeCommand(Command.FINALIZE_MODELLING);
            this.failSafeIfcEngine.writeInt(this.modelId);
            this.failSafeIfcEngine.writeInt(initialize.getIndicesCount());
            this.failSafeIfcEngine.writeInt(initialize.getVerticesCount());
            this.failSafeIfcEngine.flush();
            int[] indices = new int[initialize.getIndicesCount()];
            float[] vertices = new float[initialize.getVerticesCount() * 3];
            float[] normals = new float[initialize.getVerticesCount() * 3];
            for (i = 0; i < indices.length; ++i) {
                indices[i] = this.failSafeIfcEngine.readInt();
            }
            for (i = 0; i < vertices.length; ++i) {
                vertices[i] = this.failSafeIfcEngine.readFloat();
            }
            for (i = 0; i < normals.length; ++i) {
                normals[i] = this.failSafeIfcEngine.readFloat();
            }
            return new RenderEngineGeometry(indices, vertices, normals, null, null);
        }
    }
}

