/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcengine;

import java.util.HashMap;
import java.util.Map;

public enum Command {
    CHECK_CONNECTION,
    OPEN_MODEL,
    OPEN_MODEL_STREAMING,
    SET_POSTPROCESSING,
    FINALIZE_MODELLING,
    INITIALIZE_MODELLING,
    GET_INSTANCES,
    GET_VISUALISATION_PROPERTIES,
    CLOSE_MODEL,
    FIND_CLASHES_BY_GUID,
    FIND_CLASHES_BY_EID,
    CLOSE,
    GET_INSTANCE_FROM_EXPRESSID,
    SET_FORMAT,
    GET_TRANSFORMATION_MATRIX,
    INITIALIZE_MODELLING_INSTANCE,
    OPEN_MODEL_STREAMING_PARTS,
    SET_FILTER,
    GET_AREA,
    GET_VOLUME;

    private static final Map<Byte, Command> map;
    private byte id;

    private static Map<Byte, Command> initMap() {
        byte idCounter = 0;
        HashMap<Byte, Command> hashMap = new HashMap<Byte, Command>();
        for (Command command : Command.values()) {
            byte by = idCounter;
            idCounter = (byte)(idCounter + 1);
            byte newId = by;
            command.setId(newId);
            hashMap.put(newId, command);
        }
        return hashMap;
    }

    public static Command getCommand(byte id) {
        return map.get(id);
    }

    public byte getId() {
        return this.id;
    }

    private void setId(byte id) {
        this.id = id;
    }

    static {
        map = Command.initMap();
    }
}

