/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcengine.jvm;

import com.sun.jna.Pointer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bimserver.ifcengine.Command;
import org.bimserver.ifcengine.jvm.ConvertingInputStream;
import org.bimserver.ifcengine.jvm.IfcEngine;
import org.bimserver.ifcengine.jvm.RenderEngineInstanceVisualisationPropertiesInternal;
import org.bimserver.ifcengine.jvm.SdaiTypes;
import org.bimserver.plugins.renderengine.RenderEngineClash;
import org.bimserver.plugins.renderengine.RenderEngineException;

public class IfcEngineServer
extends Thread {
    private volatile boolean running = true;
    private final String schemaFileName;
    private IfcEngine ifcEngine;
    private final Map<Integer, Pointer> pointers = new HashMap<Integer, Pointer>();
    private int pointerCounter = 0;
    private final InputStream in;
    private final OutputStream out;
    private final PrintStream err;

    public static void main(String[] args) {
        try {
            IfcEngineServer ifcEngineServer = new IfcEngineServer(args[0], System.in, System.out, System.err);
            ifcEngineServer.run();
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
    }

    public IfcEngineServer(String schemaFileName, InputStream in, OutputStream out, PrintStream err) {
        this.schemaFileName = schemaFileName;
        this.in = in;
        this.out = out;
        this.err = err;
        this.ifcEngine = new IfcEngine();
    }

    @Override
    public void run() {
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(this.in));
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(this.out));
            while (this.running) {
                byte commandId = in.readByte();
                Command command = Command.getCommand(commandId);
                switch (command) {
                    case CHECK_CONNECTION: {
                        in.readBoolean();
                        out.writeBoolean(true);
                        break;
                    }
                    case OPEN_MODEL: {
                        String name = in.readUTF();
                        Pointer modelId = this.ifcEngine.sdaiOpenModelBN(0, name, this.schemaFileName);
                        int newPointerKey = this.savePointer(modelId);
                        out.writeInt(newPointerKey);
                        break;
                    }
                    case OPEN_MODEL_STREAMING: {
                        int size = in.readInt();
                        Pointer modelId = this.ifcEngine.loadFromInputStream(in, size, this.schemaFileName);
                        int newPointerKey = this.savePointer(modelId);
                        out.writeInt(newPointerKey);
                        break;
                    }
                    case OPEN_MODEL_STREAMING_PARTS: {
                        ConvertingInputStream convertingInputStream = new ConvertingInputStream(in);
                        Pointer modelId = this.ifcEngine.loadFromInputStream(convertingInputStream, this.schemaFileName);
                        int newPointerKey = this.savePointer(modelId);
                        out.writeInt(newPointerKey);
                        break;
                    }
                    case FINALIZE_MODELLING: {
                        int modelId = in.readInt();
                        int indicesCount = in.readInt();
                        int verticesCount = in.readInt();
                        if (indicesCount == 0 || verticesCount == 0) break;
                        boolean is64 = this.is64();
                        int[] indices = new int[indicesCount * (is64 ? 2 : 1)];
                        float[] vertices = new float[verticesCount * 3];
                        float[] normals = new float[verticesCount * 3];
                        this.ifcEngine.finalizeModelling(this.pointers.get(modelId), vertices, normals, indices);
                        boolean even = true;
                        for (int index : indices) {
                            if (!is64 || even) {
                                out.writeInt(index);
                            }
                            even = !even;
                        }
                        for (float vertex : vertices) {
                            out.writeFloat(vertex);
                        }
                        for (float normal : normals) {
                            out.writeFloat(normal);
                        }
                        break;
                    }
                    case INITIALIZE_MODELLING: {
                        int modelId = in.readInt();
                        IfcEngine.SurfaceProperties surfaceProperties = this.ifcEngine.initializeModelling(this.pointers.get(modelId), 0.0);
                        out.writeInt(surfaceProperties.getIndicesCount());
                        out.writeInt(surfaceProperties.getVerticesCount());
                        break;
                    }
                    case INITIALIZE_MODELLING_INSTANCE: {
                        int modelId = in.readInt();
                        int instanceId = in.readInt();
                        IfcEngine.SurfaceProperties surfaceProperties = this.ifcEngine.initializeModellingInstance(this.pointers.get(modelId), 0.0, this.pointers.get(instanceId));
                        out.writeInt(surfaceProperties.getIndicesCount());
                        out.writeInt(surfaceProperties.getVerticesCount());
                        break;
                    }
                    case SET_POSTPROCESSING: {
                        int modelId = in.readInt();
                        this.ifcEngine.setPostProcessing(this.pointers.get(modelId), in.readBoolean() ? 1 : 0);
                        break;
                    }
                    case GET_INSTANCES: {
                        int modelId = in.readInt();
                        String name = in.readUTF();
                        Pointer aggrId = this.ifcEngine.sdaiGetEntityExtentBN(this.pointers.get(modelId), name);
                        int nrObjects = this.ifcEngine.sdaiGetMemberCount(aggrId);
                        out.writeInt(nrObjects);
                        for (int k = 0; k < nrObjects; ++k) {
                            Pointer instanceId = (Pointer)this.ifcEngine.engiGetAggrElement(aggrId, k, SdaiTypes.INSTANCE);
                            if (!(instanceId instanceof Pointer)) {
                                throw new RenderEngineException("Unimplemented");
                            }
                            out.writeInt(this.savePointer(instanceId));
                        }
                        break;
                    }
                    case FIND_CLASHES_BY_GUID: {
                        Set<RenderEngineClash> clashes;
                        int modelId = in.readInt();
                        double dist = in.readDouble();
                        int nrClashes = this.ifcEngine.initializeClashes(this.pointers.get(modelId), dist);
                        if (nrClashes > 0) {
                            clashes = this.ifcEngine.finalizeClashesByGuid(this.pointers.get(modelId), nrClashes);
                            out.writeInt(nrClashes);
                            for (RenderEngineClash clash : clashes) {
                                out.writeUTF(clash.getGuid1());
                                out.writeUTF(clash.getGuid2());
                            }
                            break;
                        }
                        out.writeInt(0);
                        break;
                    }
                    case FIND_CLASHES_BY_EID: {
                        Set<RenderEngineClash> clashes;
                        int modelId = in.readInt();
                        double dist = in.readDouble();
                        int nrClashes = this.ifcEngine.initializeClashes(this.pointers.get(modelId), dist);
                        if (nrClashes > 0) {
                            clashes = this.ifcEngine.finalizeClashesByEI(this.pointers.get(modelId), nrClashes);
                            out.writeInt(nrClashes);
                            for (RenderEngineClash clash : clashes) {
                                out.writeLong(clash.getEid1());
                                out.writeLong(clash.getEid2());
                            }
                            break;
                        }
                        out.writeInt(0);
                        break;
                    }
                    case GET_VISUALISATION_PROPERTIES: {
                        int modelId = in.readInt();
                        int instanceId = in.readInt();
                        RenderEngineInstanceVisualisationPropertiesInternal instanceInModelling = this.ifcEngine.getInstanceInModelling(this.pointers.get(modelId), this.pointers.get(instanceId), 1);
                        out.writeInt(instanceInModelling.getStartVertex());
                        out.writeInt(instanceInModelling.getStartIndex());
                        out.writeInt(instanceInModelling.getPrimitiveCount());
                        break;
                    }
                    case CLOSE_MODEL: {
                        int modelId = in.readInt();
                        this.ifcEngine.sdaiCloseModel(this.pointers.get(modelId));
                        this.pointers.remove(modelId);
                        break;
                    }
                    case GET_AREA: {
                        int modelId = in.readInt();
                        int instanceId = in.readInt();
                        out.writeDouble(this.ifcEngine.getArea(this.pointers.get(modelId), this.pointers.get(instanceId)));
                        break;
                    }
                    case GET_VOLUME: {
                        int modelId = in.readInt();
                        int instanceId = in.readInt();
                        out.writeDouble(this.ifcEngine.getVolume(this.pointers.get(modelId), this.pointers.get(instanceId)));
                        break;
                    }
                    case SET_FORMAT: {
                        int modelId = in.readInt();
                        this.ifcEngine.setFormat(this.pointers.get(modelId), in.readInt(), in.readInt());
                        break;
                    }
                    case SET_FILTER: {
                        int modelId = in.readInt();
                        this.ifcEngine.setFilter(this.pointers.get(modelId), in.readInt(), in.readInt());
                        break;
                    }
                    case GET_INSTANCE_FROM_EXPRESSID: {
                        int modelId = in.readInt();
                        int expressId = in.readInt();
                        Pointer internalGetInstanceFromP21Line = this.ifcEngine.internalGetInstanceFromP21Line(this.pointers.get(modelId), expressId);
                        if (internalGetInstanceFromP21Line == Pointer.NULL) {
                            out.writeInt(-1);
                            break;
                        }
                        out.writeInt(this.savePointer(internalGetInstanceFromP21Line));
                        break;
                    }
                    case GET_TRANSFORMATION_MATRIX: {
                        int modelId = in.readInt();
                        int instanceId = in.readInt();
                        IfcEngine.InstanceTransformationMatrix instanceTransformationMatrix = this.ifcEngine.getInstanceTransformationMatrix(this.pointers.get(modelId), this.pointers.get(instanceId));
                        out.writeDouble(instanceTransformationMatrix._11);
                        out.writeDouble(instanceTransformationMatrix._12);
                        out.writeDouble(instanceTransformationMatrix._13);
                        out.writeDouble(instanceTransformationMatrix._14);
                        out.writeDouble(instanceTransformationMatrix._21);
                        out.writeDouble(instanceTransformationMatrix._22);
                        out.writeDouble(instanceTransformationMatrix._23);
                        out.writeDouble(instanceTransformationMatrix._24);
                        out.writeDouble(instanceTransformationMatrix._31);
                        out.writeDouble(instanceTransformationMatrix._32);
                        out.writeDouble(instanceTransformationMatrix._33);
                        out.writeDouble(instanceTransformationMatrix._34);
                        out.writeDouble(instanceTransformationMatrix._41);
                        out.writeDouble(instanceTransformationMatrix._42);
                        out.writeDouble(instanceTransformationMatrix._43);
                        out.writeDouble(instanceTransformationMatrix._44);
                        break;
                    }
                    case CLOSE: {
                        this.close();
                        System.exit(0);
                    }
                }
                out.flush();
            }
        }
        catch (IOException e) {
            if (this.running) {
                e.printStackTrace(this.err);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(this.err);
        }
    }

    private boolean is64() {
        return System.getProperty("sun.arch.data.model").equals("64");
    }

    private int savePointer(Pointer modelId) {
        int newPointerKey = this.pointerCounter++;
        this.pointers.put(newPointerKey, modelId);
        return newPointerKey;
    }

    private void close() {
        this.running = false;
    }
}

