/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.sqs;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.dataprepper.model.codec.InputCodec;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.plugins.source.sqs.MessageFieldStrategy;

public class CodecBulkMessageFieldStrategy
implements MessageFieldStrategy {
    private final InputCodec codec;

    public CodecBulkMessageFieldStrategy(InputCodec codec) {
        this.codec = codec;
    }

    @Override
    public List<Event> parseEvents(String messageBody) {
        ArrayList<Event> events = new ArrayList<Event>();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(messageBody.getBytes(StandardCharsets.UTF_8));
        try {
            this.codec.parse((InputStream)inputStream, record -> events.add((Event)record.getData()));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse events from SQS body.", e);
        }
        return events;
    }
}

