/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.sqs;

import java.util.Objects;

public class SqsSinkDlqData {
    private final String message;
    private final Object data;

    private SqsSinkDlqData(String message, Object data) {
        Objects.requireNonNull(message);
        this.message = message;
        Objects.requireNonNull(data);
        this.data = data;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqsSinkDlqData that = (SqsSinkDlqData)o;
        return Objects.equals(this.message, that.message) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.data);
    }

    public String toString() {
        return "SqsSinkDlqData{, message='" + this.message + "', data=" + String.valueOf(this.data) + "}";
    }

    public static SqsSinkDlqData createDlqData(Object data, String failureMessage) {
        return SqsSinkDlqData.builder().withData(data).withMessage(failureMessage).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String message;
        private Object data;

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withData(Object data) {
            this.data = data;
            return this;
        }

        public SqsSinkDlqData build() {
            return new SqsSinkDlqData(this.message, this.data);
        }
    }
}

