/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.NotEmpty;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>service_map</code> processor uses OpenTelemetry data to create a distributed service map for visualization in OpenSearch Dashboards.")
public class ServiceMapProcessorConfig {
    private static final String WINDOW_DURATION = "window_duration";
    static final int DEFAULT_WINDOW_DURATION = 180;
    static final String DEFAULT_DB_PATH = "data/service-map/";
    static final String DB_PATH = "db_path";
    @JsonProperty(value="window_duration", defaultValue="180")
    @JsonPropertyDescription(value="Represents the fixed time window, in seconds, during which service map relationships are evaluated.")
    private int windowDuration = 180;
    @NotEmpty
    @JsonProperty(value="db_path", defaultValue="data/service-map/")
    @JsonPropertyDescription(value="Represents folder path for creating database files storing transient data off heap memorywhen processing service-map data.")
    private String dbPath = "data/service-map/";

    public int getWindowDuration() {
        return this.windowDuration;
    }

    public String getDbPath() {
        return this.dbPath;
    }
}

