/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum NotificationSourceOption {
    S3("s3"),
    EVENTBRIDGE("eventbridge");

    private static final Map<String, NotificationSourceOption> OPTIONS_MAP;
    private final String option;

    private NotificationSourceOption(String option) {
        this.option = option.toLowerCase();
    }

    @JsonCreator
    static NotificationSourceOption fromOptionValue(String option) {
        return OPTIONS_MAP.get(option.toLowerCase());
    }

    static {
        OPTIONS_MAP = Arrays.stream(NotificationSourceOption.values()).collect(Collectors.toMap(value -> value.option, value -> value));
    }
}

