/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.s3.accumulator;

import java.util.regex.Pattern;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.plugins.s3keyindex.S3ObjectIndexUtility;
import org.opensearch.dataprepper.plugins.sink.s3.S3SinkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectKey {
    public static final Logger LOG = LoggerFactory.getLogger(ObjectKey.class);
    private static final String DEFAULT_CODEC_FILE_EXTENSION = "json";
    private static final String TIME_PATTERN_REGULAR_EXPRESSION = "\\%\\{.*?\\}";
    private static final Pattern SIMPLE_DURATION_PATTERN = Pattern.compile("\\%\\{.*?\\}");
    static final String REPLACEMENT_FOR_NON_EXISTENT_KEYS = "";

    private ObjectKey() {
    }

    public static String buildingPathPrefix(S3SinkConfig s3SinkConfig) {
        return ObjectKey.buildingPathPrefixInternal(s3SinkConfig, null, null);
    }

    public static String buildingPathPrefix(S3SinkConfig s3SinkConfig, Event event, ExpressionEvaluator expressionEvaluator) {
        return ObjectKey.buildingPathPrefixInternal(s3SinkConfig, event, expressionEvaluator);
    }

    private static String buildingPathPrefixInternal(S3SinkConfig s3SinkConfig, Event event, ExpressionEvaluator expressionEvaluator) {
        String pathPrefix = s3SinkConfig.getObjectKeyOptions().getPathPrefix();
        if (pathPrefix == null) {
            return REPLACEMENT_FOR_NON_EXISTENT_KEYS;
        }
        String pathPrefixExpressionResult = expressionEvaluator != null ? event.formatString(pathPrefix, expressionEvaluator, REPLACEMENT_FOR_NON_EXISTENT_KEYS) : pathPrefix;
        StringBuilder s3ObjectPath = new StringBuilder();
        if (pathPrefixExpressionResult != null && !pathPrefixExpressionResult.isEmpty()) {
            String[] pathPrefixList;
            for (String prefixPath : pathPrefixList = pathPrefixExpressionResult.split("\\/")) {
                if (SIMPLE_DURATION_PATTERN.matcher(prefixPath).find()) {
                    s3ObjectPath.append(S3ObjectIndexUtility.getObjectPathPrefix((String)prefixPath)).append("/");
                    continue;
                }
                s3ObjectPath.append(prefixPath).append("/");
            }
        }
        return s3ObjectPath.toString();
    }

    public static String objectFileName(S3SinkConfig s3SinkConfig, String codecExtension, Event event, ExpressionEvaluator expressionEvaluator) {
        String configNamePattern = s3SinkConfig.getObjectKeyOptions().getNamePattern();
        String configNamePatternExpressionResult = event.formatString(configNamePattern, expressionEvaluator, REPLACEMENT_FOR_NON_EXISTENT_KEYS);
        int extensionIndex = configNamePatternExpressionResult.lastIndexOf(46);
        if (extensionIndex > 0) {
            return S3ObjectIndexUtility.getObjectNameWithDateTimeId((String)configNamePatternExpressionResult.substring(0, extensionIndex)) + "." + (codecExtension != null ? codecExtension : configNamePatternExpressionResult.substring(extensionIndex + 1));
        }
        return S3ObjectIndexUtility.getObjectNameWithDateTimeId((String)configNamePatternExpressionResult) + "." + (codecExtension != null ? codecExtension : DEFAULT_CODEC_FILE_EXTENSION);
    }
}

