/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.s3.compression;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.model.codec.CompressionEngine;
import org.opensearch.dataprepper.plugins.codec.GZipCompressionEngine;
import org.opensearch.dataprepper.plugins.codec.NoneCompressionEngine;
import org.opensearch.dataprepper.plugins.codec.SnappyCompressionEngine;

public enum CompressionOption {
    NONE("none", null, NoneCompressionEngine::new),
    GZIP("gzip", "gz", GZipCompressionEngine::new),
    SNAPPY("snappy", "snappy", SnappyCompressionEngine::new);

    private static final Map<String, CompressionOption> OPTIONS_MAP;
    private final String option;
    private final String extension;
    private final Supplier<CompressionEngine> compressionEngineSupplier;

    private CompressionOption(String option, String extension, Supplier<CompressionEngine> compressionEngineSupplier) {
        this.option = option.toLowerCase();
        this.extension = extension;
        this.compressionEngineSupplier = compressionEngineSupplier;
    }

    public CompressionEngine getCompressionEngine() {
        return this.compressionEngineSupplier.get();
    }

    public String getOption() {
        return this.option;
    }

    public Optional<String> getExtension() {
        return Optional.ofNullable(this.extension);
    }

    @JsonCreator
    public static CompressionOption fromOptionValue(String option) {
        return OPTIONS_MAP.get(option);
    }

    static {
        OPTIONS_MAP = Arrays.stream(CompressionOption.values()).collect(Collectors.toMap(value -> value.option, value -> value));
    }
}

