/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.s3.accumulator;

import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.opensearch.dataprepper.model.codec.CompressionEngine;
import org.opensearch.dataprepper.plugins.sink.s3.accumulator.Buffer;

class CompressionBuffer
implements Buffer {
    private final Buffer innerBuffer;
    private final CompressionEngine compressionEngine;
    private volatile OutputStream outputStream;

    CompressionBuffer(Buffer innerBuffer, CompressionEngine compressionEngine) {
        this.innerBuffer = Objects.requireNonNull(innerBuffer);
        this.compressionEngine = Objects.requireNonNull(compressionEngine);
    }

    @Override
    public long getSize() {
        return this.innerBuffer.getSize();
    }

    @Override
    public int getEventCount() {
        return this.innerBuffer.getEventCount();
    }

    @Override
    public Duration getDuration() {
        return this.innerBuffer.getDuration();
    }

    @Override
    public Optional<CompletableFuture<?>> flushToS3(Consumer<Boolean> runOnCompletion, Consumer<Throwable> runOnException) {
        return this.innerBuffer.flushToS3(runOnCompletion, runOnException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream() {
        if (this.outputStream == null) {
            CompressionBuffer compressionBuffer = this;
            synchronized (compressionBuffer) {
                if (this.outputStream == null) {
                    OutputStream innerBufferOutputStream = this.innerBuffer.getOutputStream();
                    try {
                        this.outputStream = this.compressionEngine.createOutputStream(innerBufferOutputStream);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.outputStream;
    }

    @Override
    public void setEventCount(int eventCount) {
        this.innerBuffer.setEventCount(eventCount);
    }

    @Override
    public String getKey() {
        return this.innerBuffer.getKey();
    }
}

