/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.s3.grouping;

import java.util.Map;
import java.util.Objects;
import org.opensearch.dataprepper.plugins.sink.s3.ObjectMetadata;

class S3GroupIdentifier {
    private final Map<String, Object> groupIdentifierHash;
    private final String groupIdentifierFullObjectKey;
    private final Object objectMetadataConfig;
    private final String fullBucketName;

    public S3GroupIdentifier(Map<String, Object> groupIdentifierHash, String groupIdentifierFullObjectKey, Object objectMetadataConfig, String fullBucketName) {
        this.groupIdentifierHash = groupIdentifierHash;
        this.groupIdentifierFullObjectKey = groupIdentifierFullObjectKey;
        this.objectMetadataConfig = objectMetadataConfig;
        this.fullBucketName = fullBucketName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3GroupIdentifier that = (S3GroupIdentifier)o;
        return Objects.equals(this.groupIdentifierHash, that.groupIdentifierHash);
    }

    public int hashCode() {
        return Objects.hash(this.groupIdentifierHash);
    }

    public String getGroupIdentifierFullObjectKey() {
        return this.groupIdentifierFullObjectKey;
    }

    public Map<String, Object> getGroupIdentifierHash() {
        return this.groupIdentifierHash;
    }

    public Map<String, String> getMetadata(int eventCount) {
        if (this.objectMetadataConfig == null) {
            return null;
        }
        ObjectMetadata objectMetadata = new ObjectMetadata(this.objectMetadataConfig);
        objectMetadata.setEventCount(eventCount);
        return objectMetadata.get();
    }

    public String getFullBucketName() {
        return this.fullBucketName;
    }
}

