/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.s3.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import org.hibernate.validator.constraints.time.DurationMax;
import org.hibernate.validator.constraints.time.DurationMin;
import org.opensearch.dataprepper.model.types.ByteCount;

public class ThresholdOptions {
    private static final String DEFAULT_BYTE_CAPACITY = "50mb";
    @JsonProperty(value="event_count")
    @Min(value=0L, message="event_count size should be between 0 and 10000000")
    @Max(value=10000000L, message="event_count size should be between 0 and 10000000")
    private @Min(value=0L, message="event_count size should be between 0 and 10000000") @Max(value=10000000L, message="event_count size should be between 0 and 10000000") int eventCount;
    @JsonProperty(value="maximum_size")
    private ByteCount maximumSize = ByteCount.parse((String)"50mb");
    @JsonProperty(value="event_collect_timeout")
    @DurationMin(seconds=1L)
    @DurationMax(seconds=3600L)
    @NotNull
    private @DurationMin(seconds=1L) @DurationMax(seconds=3600L) @NotNull Duration eventCollectTimeOut;

    public Duration getEventCollectTimeOut() {
        return this.eventCollectTimeOut;
    }

    public ByteCount getMaximumSize() {
        return this.maximumSize;
    }

    public int getEventCount() {
        return this.eventCount;
    }
}

