/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.utils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class IdentifierShortener {
    public static String shortenIdentifier(String identifier, int maxLength) {
        if (identifier.length() <= maxLength) {
            return identifier;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] encodedhash = digest.digest(identifier.getBytes(StandardCharsets.UTF_8));
            String base64Hash = Base64.getUrlEncoder().withoutPadding().encodeToString(encodedhash);
            return base64Hash.substring(0, Math.min(base64Hash.length(), maxLength));
        }
        catch (NoSuchAlgorithmException e) {
            return identifier.substring(0, maxLength);
        }
    }
}

