/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.resync;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.opensearch.dataprepper.common.concurrent.BackgroundThreadFactory;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.source.rds.RdsSourceConfig;
import org.opensearch.dataprepper.plugins.source.rds.converter.RecordConverter;
import org.opensearch.dataprepper.plugins.source.rds.converter.StreamRecordConverter;
import org.opensearch.dataprepper.plugins.source.rds.coordination.partition.GlobalState;
import org.opensearch.dataprepper.plugins.source.rds.coordination.partition.ResyncPartition;
import org.opensearch.dataprepper.plugins.source.rds.model.DbTableMetadata;
import org.opensearch.dataprepper.plugins.source.rds.resync.MySQLResyncWorker;
import org.opensearch.dataprepper.plugins.source.rds.schema.QueryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResyncScheduler
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ResyncScheduler.class);
    private static final int DEFAULT_TAKE_LEASE_INTERVAL_MILLIS = 60000;
    private static final int DEFAULT_NUM_RESYNC_WORKERS = 1;
    private final EnhancedSourceCoordinator sourceCoordinator;
    private final RdsSourceConfig sourceConfig;
    private final QueryManager queryManager;
    private final String s3Prefix;
    private final Buffer<Record<Event>> buffer;
    private final RecordConverter recordConverter;
    private final PluginMetrics pluginMetrics;
    private final AcknowledgementSetManager acknowledgementSetManager;
    private final ExecutorService resyncExecutor;
    private volatile boolean shutdownRequested = false;

    public ResyncScheduler(EnhancedSourceCoordinator sourceCoordinator, RdsSourceConfig sourceConfig, QueryManager queryManager, String s3Prefix, Buffer<Record<Event>> buffer, PluginMetrics pluginMetrics, AcknowledgementSetManager acknowledgementSetManager) {
        this.sourceCoordinator = sourceCoordinator;
        this.sourceConfig = sourceConfig;
        this.queryManager = queryManager;
        this.s3Prefix = s3Prefix;
        this.buffer = buffer;
        this.recordConverter = new StreamRecordConverter(s3Prefix, sourceConfig.getPartitionCount());
        this.pluginMetrics = pluginMetrics;
        this.acknowledgementSetManager = acknowledgementSetManager;
        this.resyncExecutor = Executors.newFixedThreadPool(1, (ThreadFactory)BackgroundThreadFactory.defaultExecutorThreadFactory((String)"rds-source-resync-worker"));
    }

    @Override
    public void run() {
        LOG.info("Start running Resync Scheduler");
        ResyncPartition resyncPartition = null;
        while (!this.shutdownRequested && !Thread.currentThread().isInterrupted()) {
            try {
                Optional sourcePartition = this.sourceCoordinator.acquireAvailablePartition("RESYNC");
                if (sourcePartition.isPresent()) {
                    LOG.info("Acquired partition to perform resync");
                    resyncPartition = (ResyncPartition)((Object)sourcePartition.get());
                    this.processResyncPartition(resyncPartition);
                }
                try {
                    Thread.sleep(60000L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOG.info("The ResyncScheduler was interrupted while waiting to retry, stopping processing");
                }
            }
            catch (Exception e) {
                LOG.error("Received an exception during resync, backing off and retrying", (Throwable)e);
                if (resyncPartition != null) {
                    this.sourceCoordinator.giveUpPartition(resyncPartition);
                }
                try {
                    Thread.sleep(60000L);
                    continue;
                }
                catch (InterruptedException ex) {
                    LOG.info("The StreamScheduler was interrupted while waiting to retry, stopping processing");
                }
            }
            break;
        }
    }

    public void shutdown() {
        this.shutdownRequested = true;
    }

    private void processResyncPartition(ResyncPartition resyncPartition) {
        LOG.info("Processing resync partition: {}", (Object)resyncPartition.getPartitionKey());
        AcknowledgementSet acknowledgementSet = null;
        if (this.sourceConfig.isAcknowledgmentsEnabled()) {
            acknowledgementSet = this.acknowledgementSetManager.create(result -> {
                if (result.booleanValue()) {
                    this.sourceCoordinator.completePartition((EnhancedSourcePartition)resyncPartition);
                    LOG.info("Received acknowledgment of completion from sink for resync partition {}", (Object)resyncPartition.getPartitionKey());
                } else {
                    LOG.warn("Negative acknowledgment received for resync partition {}, retrying", (Object)resyncPartition.getPartitionKey());
                    this.sourceCoordinator.giveUpPartition((EnhancedSourcePartition)resyncPartition);
                }
            }, this.sourceConfig.getStreamAcknowledgmentTimeout());
        }
        MySQLResyncWorker resyncWorker = MySQLResyncWorker.create(resyncPartition, this.sourceConfig, this.queryManager, this.buffer, this.recordConverter, acknowledgementSet, this.getDBTableMetadata());
        CompletableFuture.runAsync(resyncWorker, this.resyncExecutor).whenComplete((v, ex) -> {
            if (ex != null) {
                LOG.error("There was an exception while processing a resync partition", ex);
                this.sourceCoordinator.giveUpPartition((EnhancedSourcePartition)resyncPartition);
            } else {
                LOG.info("Completed processing resync partition {}", (Object)resyncPartition.getPartitionKey());
                if (!this.sourceConfig.isAcknowledgmentsEnabled()) {
                    this.sourceCoordinator.completePartition((EnhancedSourcePartition)resyncPartition);
                }
            }
        });
    }

    private DbTableMetadata getDBTableMetadata() {
        Optional globalStatePartition = this.sourceCoordinator.getPartition(this.sourceConfig.getDbIdentifier());
        GlobalState globalState = (GlobalState)((Object)globalStatePartition.get());
        return DbTableMetadata.fromMap(globalState.getProgressState().get());
    }
}

