/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.datatype.mysql;

import java.util.HashMap;
import java.util.Map;

public enum MySQLDataType {
    TINYINT("tinyint", DataCategory.NUMERIC, DataSubCategory.SIGNED),
    TINYINT_UNSIGNED("tinyint unsigned", DataCategory.NUMERIC, DataSubCategory.UNSIGNED),
    SMALLINT("smallint", DataCategory.NUMERIC, DataSubCategory.SIGNED),
    SMALLINT_UNSIGNED("smallint unsigned", DataCategory.NUMERIC, DataSubCategory.UNSIGNED),
    MEDIUMINT("mediumint", DataCategory.NUMERIC, DataSubCategory.SIGNED),
    MEDIUMINT_UNSIGNED("mediumint unsigned", DataCategory.NUMERIC, DataSubCategory.UNSIGNED),
    INT("int", DataCategory.NUMERIC, DataSubCategory.SIGNED),
    INT_UNSIGNED("int unsigned", DataCategory.NUMERIC, DataSubCategory.UNSIGNED),
    BIGINT("bigint", DataCategory.NUMERIC, DataSubCategory.SIGNED),
    BIGINT_UNSIGNED("bigint unsigned", DataCategory.NUMERIC, DataSubCategory.UNSIGNED),
    DECIMAL("decimal", DataCategory.NUMERIC, DataSubCategory.SIGNED),
    FLOAT("float", DataCategory.NUMERIC, DataSubCategory.SIGNED),
    DOUBLE("double", DataCategory.NUMERIC, DataSubCategory.SIGNED),
    BIT("bit", DataCategory.NUMERIC, DataSubCategory.BIT),
    CHAR("char", DataCategory.STRING, DataSubCategory.CHAR),
    VARCHAR("varchar", DataCategory.STRING, DataSubCategory.CHAR),
    TINYTEXT("tinytext", DataCategory.STRING, DataSubCategory.BYTES),
    TEXT("text", DataCategory.STRING, DataSubCategory.BYTES),
    MEDIUMTEXT("mediumtext", DataCategory.STRING, DataSubCategory.BYTES),
    LONGTEXT("longtext", DataCategory.STRING, DataSubCategory.BYTES),
    ENUM("enum", DataCategory.STRING, DataSubCategory.ENUM),
    SET("set", DataCategory.STRING, DataSubCategory.SET),
    DATE("date", DataCategory.TEMPORAL),
    TIME("time", DataCategory.TEMPORAL),
    DATETIME("datetime", DataCategory.TEMPORAL),
    TIMESTAMP("timestamp", DataCategory.TEMPORAL),
    YEAR("year", DataCategory.TEMPORAL),
    BINARY("binary", DataCategory.BINARY),
    VARBINARY("varbinary", DataCategory.BINARY),
    TINYBLOB("tinyblob", DataCategory.BINARY),
    BLOB("blob", DataCategory.BINARY),
    MEDIUMBLOB("mediumblob", DataCategory.BINARY),
    LONGBLOB("longblob", DataCategory.BINARY),
    JSON("json", DataCategory.JSON),
    GEOMETRY("geometry", DataCategory.SPATIAL);

    private static final Map<String, MySQLDataType> TYPE_MAP;
    private final String dataType;
    private final DataCategory category;
    private final DataSubCategory subCategory;

    private MySQLDataType(String dataType, DataCategory category) {
        this.dataType = dataType;
        this.category = category;
        this.subCategory = null;
    }

    private MySQLDataType(String dataType, DataCategory category, DataSubCategory subCategory) {
        this.dataType = dataType;
        this.category = category;
        this.subCategory = subCategory;
    }

    public String getDataType() {
        return this.dataType;
    }

    public DataCategory getCategory() {
        return this.category;
    }

    public DataSubCategory getSubCategory() {
        return this.subCategory;
    }

    public static MySQLDataType byDataType(String dataType) {
        MySQLDataType type = TYPE_MAP.get(dataType.toLowerCase());
        if (type == null) {
            throw new IllegalArgumentException("Unsupported MySQL data type: " + dataType);
        }
        return type;
    }

    public boolean isNumeric() {
        return this.category == DataCategory.NUMERIC;
    }

    public boolean isNumericUnsigned() {
        return this.category == DataCategory.NUMERIC && this.subCategory == DataSubCategory.UNSIGNED;
    }

    public boolean isBigIntUnsigned() {
        return this == BIGINT_UNSIGNED;
    }

    public boolean isBit() {
        return this == BIT;
    }

    public boolean isString() {
        return this.category == DataCategory.STRING;
    }

    public boolean isStringBytes() {
        return this.category == DataCategory.STRING && this.subCategory == DataSubCategory.BYTES;
    }

    public boolean isStringSet() {
        return this.category == DataCategory.STRING && this.subCategory == DataSubCategory.SET;
    }

    public boolean isStringEnum() {
        return this.category == DataCategory.STRING && this.subCategory == DataSubCategory.ENUM;
    }

    public boolean isTemporal() {
        return this.category == DataCategory.TEMPORAL;
    }

    public boolean isBinary() {
        return this.category == DataCategory.BINARY;
    }

    public boolean isJson() {
        return this.category == DataCategory.JSON;
    }

    public boolean isSpatial() {
        return this.category == DataCategory.SPATIAL;
    }

    public long getUnsignedMask() {
        switch (this) {
            case TINYINT_UNSIGNED: {
                return 255L;
            }
            case SMALLINT_UNSIGNED: {
                return 65535L;
            }
            case MEDIUMINT_UNSIGNED: {
                return 0xFFFFFFL;
            }
            case INT_UNSIGNED: {
                return 0xFFFFFFFFL;
            }
            case BIGINT_UNSIGNED: {
                return -1L;
            }
        }
        throw new UnsupportedOperationException("No mask for non-unsigned type: " + String.valueOf((Object)this));
    }

    static {
        TYPE_MAP = new HashMap<String, MySQLDataType>(MySQLDataType.values().length);
        for (MySQLDataType dataType : MySQLDataType.values()) {
            TYPE_MAP.put(dataType.dataType, dataType);
        }
    }

    public static enum DataSubCategory {
        BIT,
        SIGNED,
        UNSIGNED,
        CHAR,
        BYTES,
        TEMPORAL,
        BINARY,
        JSON,
        SPATIAL,
        ENUM,
        SET;

    }

    public static enum DataCategory {
        NUMERIC,
        STRING,
        TEMPORAL,
        BINARY,
        JSON,
        SPATIAL;

    }
}

