/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.coordination.state;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.plugins.source.rds.configuration.EngineType;

public class DataFileProgressState {
    @JsonProperty(value="engineType")
    private String engineType;
    @JsonProperty(value="isLoaded")
    private boolean isLoaded = false;
    @JsonProperty(value="totalRecords")
    private int totalRecords;
    @JsonProperty(value="sourceDatabase")
    private String sourceDatabase;
    @JsonProperty(value="sourceSchema")
    private String sourceSchema;
    @JsonProperty(value="sourceTable")
    private String sourceTable;
    @JsonProperty(value="primaryKeyMap")
    private Map<String, List<String>> primaryKeyMap;
    @JsonProperty(value="snapshotTime")
    private long snapshotTime;

    public String getEngineType() {
        return this.engineType;
    }

    public void setEngineType(String engineType) {
        this.engineType = engineType;
    }

    public int getTotalRecords() {
        return this.totalRecords;
    }

    public void setTotalRecords(int totalRecords) {
        this.totalRecords = totalRecords;
    }

    public boolean getLoaded() {
        return this.isLoaded;
    }

    public void setLoaded(boolean loaded) {
        this.isLoaded = loaded;
    }

    public String getSourceDatabase() {
        return this.sourceDatabase;
    }

    public void setSourceDatabase(String sourceDatabase) {
        this.sourceDatabase = sourceDatabase;
    }

    public String getSourceSchema() {
        return this.sourceSchema;
    }

    public void setSourceSchema(String sourceSchema) {
        this.sourceSchema = sourceSchema;
    }

    @JsonIgnore
    public String getFullSourceTableName() {
        if (EngineType.fromString(this.engineType).isMySql()) {
            return this.sourceDatabase + "." + this.sourceTable;
        }
        if (EngineType.fromString(this.engineType).isPostgres()) {
            return this.sourceDatabase + "." + this.sourceSchema + "." + this.sourceTable;
        }
        throw new RuntimeException("Unsupported engine type: " + this.engineType);
    }

    public String getSourceTable() {
        return this.sourceTable;
    }

    public void setSourceTable(String sourceTable) {
        this.sourceTable = sourceTable;
    }

    public long getSnapshotTime() {
        return this.snapshotTime;
    }

    public void setSnapshotTime(long snapshotTime) {
        this.snapshotTime = snapshotTime;
    }

    public Map<String, List<String>> getPrimaryKeyMap() {
        return this.primaryKeyMap;
    }

    public void setPrimaryKeyMap(Map<String, List<String>> primaryKeyMap) {
        this.primaryKeyMap = primaryKeyMap;
    }
}

