/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.converter;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventMetadata;
import org.opensearch.dataprepper.model.opensearch.OpenSearchBulkActions;
import org.opensearch.dataprepper.plugins.source.rds.converter.S3PartitionCreator;
import org.opensearch.dataprepper.plugins.source.rds.model.StreamEventType;

public abstract class RecordConverter {
    private final String s3Prefix;
    private final List<String> folderNames;
    static final String S3_BUFFER_PREFIX = "buffer";
    static final String S3_PATH_DELIMITER = "/";
    static final String EXPORT_INGESTION_TYPE = "EXPORT";
    static final String STREAM_INGESTION_TYPE = "STREAM";

    public RecordConverter(String s3Prefix, int partitionCount) {
        this.s3Prefix = s3Prefix;
        S3PartitionCreator s3PartitionCreator = new S3PartitionCreator(partitionCount);
        this.folderNames = s3PartitionCreator.createPartitions();
    }

    public Event convert(Event event, String databaseName, String schemaName, String tableName, OpenSearchBulkActions bulkAction, List<String> primaryKeys, long eventCreateTimeEpochMillis, long eventVersionNumber, StreamEventType eventType) {
        EventMetadata eventMetadata = event.getMetadata();
        if (STREAM_INGESTION_TYPE.equals(this.getIngestionType())) {
            Instant externalOriginationTime = Instant.ofEpochMilli(eventCreateTimeEpochMillis);
            event.getEventHandle().setExternalOriginationTime(externalOriginationTime);
            eventMetadata.setExternalOriginationTime(externalOriginationTime);
        }
        eventMetadata.setAttribute("database_name", (Object)databaseName);
        eventMetadata.setAttribute("schema_name", (Object)schemaName);
        eventMetadata.setAttribute("table_name", (Object)tableName);
        eventMetadata.setAttribute("opensearch_action", (Object)bulkAction.toString());
        this.setIngestionTypeMetadata(event);
        if (eventType != null) {
            eventMetadata.setAttribute("change_event_type", (Object)eventType.toString());
        }
        String primaryKeyValue = primaryKeys.stream().map(key -> (String)event.get(key, String.class)).collect(Collectors.joining("|"));
        eventMetadata.setAttribute("primary_key", (Object)primaryKeyValue);
        String s3PartitionKey = this.s3Prefix + "/buffer/" + this.hashKeyToPartition(primaryKeyValue);
        eventMetadata.setAttribute("s3_partition_key", (Object)s3PartitionKey);
        eventMetadata.setAttribute("event_timestamp", (Object)eventCreateTimeEpochMillis);
        eventMetadata.setAttribute("document_version", (Object)eventVersionNumber);
        return event;
    }

    abstract String getIngestionType();

    private void setIngestionTypeMetadata(Event event) {
        event.getMetadata().setAttribute("ingestion_type", (Object)this.getIngestionType());
    }

    private String hashKeyToPartition(String key) {
        return this.folderNames.get(this.hashKeyToIndex(key));
    }

    private int hashKeyToIndex(String key) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest(key.getBytes());
            int hashValue = this.bytesToInt(hashBytes);
            return Math.abs(hashValue) % this.folderNames.size();
        }
        catch (NoSuchAlgorithmException e) {
            return -1;
        }
    }

    private int bytesToInt(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getInt();
    }
}

