/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.schema;

import org.opensearch.dataprepper.plugins.source.rds.RdsSourceConfig;
import org.opensearch.dataprepper.plugins.source.rds.model.DbMetadata;
import org.opensearch.dataprepper.plugins.source.rds.schema.ConnectionManager;
import org.opensearch.dataprepper.plugins.source.rds.schema.MySqlConnectionManager;
import org.opensearch.dataprepper.plugins.source.rds.schema.PostgresConnectionManager;

public class ConnectionManagerFactory {
    private final RdsSourceConfig sourceConfig;
    private final DbMetadata dbMetadata;

    public ConnectionManagerFactory(RdsSourceConfig sourceConfig, DbMetadata dbMetadata) {
        this.sourceConfig = sourceConfig;
        this.dbMetadata = dbMetadata;
    }

    public ConnectionManager getConnectionManager() {
        if (this.sourceConfig.getEngine().isMySql()) {
            return new MySqlConnectionManager(this.dbMetadata.getEndpoint(), this.dbMetadata.getPort(), this.sourceConfig.getAuthenticationConfig().getUsername(), this.sourceConfig.getAuthenticationConfig().getPassword(), this.sourceConfig.isTlsEnabled());
        }
        return new PostgresConnectionManager(this.dbMetadata.getEndpoint(), this.dbMetadata.getPort(), this.sourceConfig.getAuthenticationConfig().getUsername(), this.sourceConfig.getAuthenticationConfig().getPassword(), this.sourceConfig.isTlsEnabled(), this.sourceConfig.getDatabase());
    }
}

