/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.plugins.source.rds.configuration.AwsAuthenticationConfig;
import org.opensearch.dataprepper.plugins.source.rds.configuration.EngineType;
import org.opensearch.dataprepper.plugins.source.rds.configuration.ExportConfig;
import org.opensearch.dataprepper.plugins.source.rds.configuration.TableFilterConfig;
import org.opensearch.dataprepper.plugins.source.rds.configuration.TlsConfig;
import software.amazon.awssdk.regions.Region;

public class RdsSourceConfig {
    private static final int DEFAULT_S3_FOLDER_PARTITION_COUNT = 100;
    @JsonProperty(value="db_identifier")
    @NotBlank
    private String dbIdentifier;
    @JsonProperty(value="cluster")
    private boolean isCluster = false;
    @JsonProperty(value="engine")
    @NotNull
    private EngineType engine;
    @JsonProperty(value="database")
    @NotEmpty
    private String database;
    @JsonProperty(value="tables")
    private TableFilterConfig tableFilterConfig;
    @JsonProperty(value="aws")
    @NotNull
    @Valid
    private AwsAuthenticationConfig awsAuthenticationConfig;
    @JsonProperty(value="acknowledgments")
    private boolean acknowledgments = true;
    @JsonProperty(value="s3_data_file_acknowledgment_timeout")
    private Duration dataFileAcknowledgmentTimeout = Duration.ofMinutes(30L);
    @JsonProperty(value="stream_acknowledgment_timeout")
    private Duration streamAcknowledgmentTimeout = Duration.ofMinutes(10L);
    @JsonProperty(value="s3_bucket")
    @NotBlank
    private String s3Bucket;
    @JsonProperty(value="s3_prefix")
    private String s3Prefix;
    @JsonProperty(value="s3_region")
    private String s3Region;
    @JsonProperty(value="partition_count")
    @Min(value=1L)
    @Max(value=1000L)
    private @Min(value=1L) @Max(value=1000L) int s3FolderPartitionCount = 100;
    @JsonProperty(value="export")
    @Valid
    private ExportConfig exportConfig;
    @JsonProperty(value="stream")
    private boolean enableStream;
    @JsonProperty(value="authentication")
    @NotNull
    private AuthenticationConfig authenticationConfig;
    @JsonProperty(value="tls")
    private TlsConfig tlsConfig;
    @JsonProperty(value="disable_s3_read_for_leader")
    private boolean disableS3ReadForLeader = false;

    public String getDbIdentifier() {
        return this.dbIdentifier;
    }

    public boolean isCluster() {
        return this.isCluster || this.isAurora();
    }

    public EngineType getEngine() {
        return this.engine;
    }

    public boolean isAurora() {
        return this.engine.isAurora();
    }

    public String getDatabase() {
        return this.database;
    }

    public TableFilterConfig getTables() {
        return this.tableFilterConfig;
    }

    public AwsAuthenticationConfig getAwsAuthenticationConfig() {
        return this.awsAuthenticationConfig;
    }

    public boolean isAcknowledgmentsEnabled() {
        return this.acknowledgments;
    }

    public Duration getDataFileAcknowledgmentTimeout() {
        return this.dataFileAcknowledgmentTimeout;
    }

    public Duration getStreamAcknowledgmentTimeout() {
        return this.streamAcknowledgmentTimeout;
    }

    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public String getS3Prefix() {
        return this.s3Prefix;
    }

    public Region getS3Region() {
        return this.s3Region != null ? Region.of((String)this.s3Region) : null;
    }

    public int getPartitionCount() {
        return this.s3FolderPartitionCount;
    }

    public ExportConfig getExport() {
        return this.exportConfig;
    }

    public boolean isExportEnabled() {
        return this.exportConfig != null;
    }

    public boolean isStreamEnabled() {
        return this.enableStream;
    }

    public TlsConfig getTlsConfig() {
        return this.tlsConfig;
    }

    public boolean isTlsEnabled() {
        return this.tlsConfig == null || !this.tlsConfig.isInsecure();
    }

    public boolean isDisableS3ReadForLeader() {
        return this.disableS3ReadForLeader;
    }

    public AuthenticationConfig getAuthenticationConfig() {
        return this.authenticationConfig;
    }

    public void applyTableFilter(Set<String> tableNames) {
        if (this.tableFilterConfig == null) {
            return;
        }
        if (!this.tableFilterConfig.getInclude().isEmpty()) {
            List includeTableList = this.tableFilterConfig.getInclude().stream().map(item -> this.getDatabase() + "." + item).collect(Collectors.toList());
            tableNames.retainAll(includeTableList);
        }
        if (!this.tableFilterConfig.getExclude().isEmpty()) {
            List<String> excludeTableList = this.tableFilterConfig.getExclude().stream().map(item -> this.getDatabase() + "." + item).collect(Collectors.toList());
            excludeTableList.forEach(tableNames::remove);
        }
    }

    public static class AuthenticationConfig {
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="password")
        private String password;

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

