/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.schema;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.opensearch.dataprepper.plugins.source.rds.schema.MySqlConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryManager {
    private static final Logger LOG = LoggerFactory.getLogger(QueryManager.class);
    static final int NUM_OF_RETRIES = 3;
    static final int BACKOFF_IN_MILLIS = 500;
    private final MySqlConnectionManager connectionManager;

    public QueryManager(MySqlConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public List<Map<String, Object>> selectRows(String query) {
        return this.executeWithRetry(this::doSelectRows, query);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<Map<String, Object>> doSelectRows(String query) {
        ArrayList result = new ArrayList();
        try (Connection connection = this.connectionManager.getConnection();){
            List<Map<String, Object>> list;
            block14: {
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(query);
                try {
                    list = this.convertResultSetToList(resultSet);
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return list;
        }
        catch (Exception e) {
            LOG.error("Failed to execute query {}, retrying", (Object)query);
            throw new RuntimeException(e);
        }
    }

    private List<Map<String, Object>> convertResultSetToList(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        while (resultSet.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                row.put(metaData.getColumnName(i), resultSet.getObject(i));
            }
            result.add(row);
        }
        return result;
    }

    private <T, R> R executeWithRetry(Function<T, R> function, T query) {
        for (int retry = 0; retry <= 3; ++retry) {
            try {
                return function.apply(query);
            }
            catch (Exception e) {
                this.applyBackoff();
                continue;
            }
        }
        throw new RuntimeException("Failed to execute query after 3 retries");
    }

    private void applyBackoff() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

