/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.model;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum MessageType {
    BEGIN('B'),
    COMMIT('C'),
    DELETE('D'),
    INSERT('I'),
    MESSAGE('M'),
    ORIGIN('O'),
    RELATION('R'),
    TRUNCATE('T'),
    TYPE('Y'),
    UPDATE('U');

    private final char value;
    private static final Map<Character, MessageType> MESSAGE_TYPE_MAP;

    private MessageType(char value) {
        this.value = value;
    }

    public char getValue() {
        return this.value;
    }

    public static MessageType from(char value) {
        if (!MESSAGE_TYPE_MAP.containsKey(Character.valueOf(value))) {
            throw new IllegalArgumentException("Invalid MessageType value: " + value);
        }
        return MESSAGE_TYPE_MAP.get(Character.valueOf(value));
    }

    static {
        MESSAGE_TYPE_MAP = Arrays.stream(MessageType.values()).collect(Collectors.toMap(messageType -> Character.valueOf(messageType.value), messageType -> messageType));
    }
}

