/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.leader;

import java.time.Instant;
import org.opensearch.dataprepper.plugins.source.rds.leader.RdsApiStrategy;
import org.opensearch.dataprepper.plugins.source.rds.model.DbMetadata;
import org.opensearch.dataprepper.plugins.source.rds.model.SnapshotInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.CreateDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.CreateDbSnapshotResponse;
import software.amazon.awssdk.services.rds.model.DBInstance;
import software.amazon.awssdk.services.rds.model.DBSnapshot;
import software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse;

public class InstanceApiStrategy
implements RdsApiStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceApiStrategy.class);
    private final RdsClient rdsClient;

    public InstanceApiStrategy(RdsClient rdsClient) {
        this.rdsClient = rdsClient;
    }

    @Override
    public DbMetadata describeDb(String dbIdentifier) {
        try {
            DescribeDbInstancesRequest request = (DescribeDbInstancesRequest)DescribeDbInstancesRequest.builder().dbInstanceIdentifier(dbIdentifier).build();
            DescribeDbInstancesResponse response = this.rdsClient.describeDBInstances(request);
            DBInstance dbInstance = (DBInstance)response.dbInstances().get(0);
            DbMetadata.DbMetadataBuilder dbMetadataBuilder = DbMetadata.builder().dbIdentifier(dbIdentifier).endpoint(dbInstance.endpoint().address()).port(dbInstance.endpoint().port());
            if (!dbInstance.readReplicaDBInstanceIdentifiers().isEmpty()) {
                DescribeDbInstancesRequest readerInstanceRequest = (DescribeDbInstancesRequest)DescribeDbInstancesRequest.builder().dbInstanceIdentifier((String)dbInstance.readReplicaDBInstanceIdentifiers().get(0)).build();
                DescribeDbInstancesResponse readerInstanceResponse = this.rdsClient.describeDBInstances(readerInstanceRequest);
                DBInstance readerInstance = (DBInstance)readerInstanceResponse.dbInstances().get(0);
                dbMetadataBuilder.readerEndpoint(readerInstance.endpoint().address()).readerPort(readerInstance.endpoint().port());
            }
            return dbMetadataBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to describe DB " + dbIdentifier, e);
        }
    }

    @Override
    public SnapshotInfo createSnapshot(String dbIdentifier, String snapshotId) {
        CreateDbSnapshotRequest request = (CreateDbSnapshotRequest)CreateDbSnapshotRequest.builder().dbInstanceIdentifier(dbIdentifier).dbSnapshotIdentifier(snapshotId).build();
        try {
            CreateDbSnapshotResponse response = this.rdsClient.createDBSnapshot(request);
            String snapshotArn = response.dbSnapshot().dbSnapshotArn();
            String status = response.dbSnapshot().status();
            Instant createTime = response.dbSnapshot().snapshotCreateTime();
            LOG.info("Creating snapshot with id {} for {} and the current status is {}", new Object[]{snapshotId, dbIdentifier, status});
            return new SnapshotInfo(snapshotId, snapshotArn, createTime, status);
        }
        catch (Exception e) {
            LOG.error("Failed to create snapshot for {}", (Object)dbIdentifier, (Object)e);
            return null;
        }
    }

    @Override
    public SnapshotInfo describeSnapshot(String snapshotId) {
        DescribeDbSnapshotsRequest request = (DescribeDbSnapshotsRequest)DescribeDbSnapshotsRequest.builder().dbSnapshotIdentifier(snapshotId).build();
        try {
            DescribeDbSnapshotsResponse response = this.rdsClient.describeDBSnapshots(request);
            String snapshotArn = ((DBSnapshot)response.dbSnapshots().get(0)).dbSnapshotArn();
            String status = ((DBSnapshot)response.dbSnapshots().get(0)).status();
            Instant createTime = ((DBSnapshot)response.dbSnapshots().get(0)).snapshotCreateTime();
            return new SnapshotInfo(snapshotId, snapshotArn, createTime, status);
        }
        catch (Exception e) {
            LOG.error("Failed to describe snapshot {}", (Object)snapshotId, (Object)e);
            return null;
        }
    }
}

