/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.stream;

import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.opensearch.dataprepper.common.concurrent.BackgroundThreadFactory;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.PluginConfigObservable;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.source.rds.RdsSourceConfig;
import org.opensearch.dataprepper.plugins.source.rds.coordination.partition.StreamPartition;
import org.opensearch.dataprepper.plugins.source.rds.stream.ReplicationLogClientFactory;
import org.opensearch.dataprepper.plugins.source.rds.stream.StreamCheckpointer;
import org.opensearch.dataprepper.plugins.source.rds.stream.StreamWorkerTaskRefresher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamScheduler
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(StreamScheduler.class);
    private static final int DEFAULT_TAKE_LEASE_INTERVAL_MILLIS = 60000;
    private final EnhancedSourceCoordinator sourceCoordinator;
    private final RdsSourceConfig sourceConfig;
    private final String s3Prefix;
    private ReplicationLogClientFactory replicationLogClientFactory;
    private final Buffer<Record<Event>> buffer;
    private final PluginMetrics pluginMetrics;
    private final AcknowledgementSetManager acknowledgementSetManager;
    private final PluginConfigObservable pluginConfigObservable;
    private StreamWorkerTaskRefresher streamWorkerTaskRefresher;
    private volatile boolean shutdownRequested = false;

    public StreamScheduler(EnhancedSourceCoordinator sourceCoordinator, RdsSourceConfig sourceConfig, String s3Prefix, ReplicationLogClientFactory replicationLogClientFactory, Buffer<Record<Event>> buffer, PluginMetrics pluginMetrics, AcknowledgementSetManager acknowledgementSetManager, PluginConfigObservable pluginConfigObservable) {
        this.sourceCoordinator = sourceCoordinator;
        this.sourceConfig = sourceConfig;
        this.s3Prefix = s3Prefix;
        this.replicationLogClientFactory = replicationLogClientFactory;
        this.buffer = buffer;
        this.pluginMetrics = pluginMetrics;
        this.acknowledgementSetManager = acknowledgementSetManager;
        this.pluginConfigObservable = pluginConfigObservable;
    }

    @Override
    public void run() {
        LOG.debug("Start running Stream Scheduler");
        StreamPartition streamPartition = null;
        while (!this.shutdownRequested && !Thread.currentThread().isInterrupted()) {
            try {
                Optional sourcePartition = this.sourceCoordinator.acquireAvailablePartition("STREAM");
                if (sourcePartition.isPresent()) {
                    LOG.info("Acquired partition to read from stream");
                    if (this.sourceConfig.isDisableS3ReadForLeader()) {
                        System.setProperty("STOP_S3_SCAN_PROCESSING", "true");
                    }
                    streamPartition = (StreamPartition)((Object)sourcePartition.get());
                    StreamCheckpointer streamCheckpointer = new StreamCheckpointer(this.sourceCoordinator, streamPartition, this.pluginMetrics);
                    if (this.streamWorkerTaskRefresher != null) {
                        this.streamWorkerTaskRefresher.shutdown();
                    }
                    this.streamWorkerTaskRefresher = StreamWorkerTaskRefresher.create(this.sourceCoordinator, streamPartition, streamCheckpointer, this.s3Prefix, this.replicationLogClientFactory, this.buffer, () -> Executors.newSingleThreadExecutor((ThreadFactory)BackgroundThreadFactory.defaultExecutorThreadFactory((String)"rds-source-stream-worker")), this.acknowledgementSetManager, this.pluginMetrics);
                    this.streamWorkerTaskRefresher.initialize(this.sourceConfig);
                    LOG.debug("Add plugin config observer for refreshing stream worker");
                    this.pluginConfigObservable.addPluginConfigObserver(pluginConfig -> this.streamWorkerTaskRefresher.update((RdsSourceConfig)pluginConfig));
                }
                LOG.debug("Looping to acquire new stream partition or idle while stream worker is working");
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                LOG.info("The StreamScheduler was interrupted, stopping processing");
                this.giveUpPartition(streamPartition);
                break;
            }
            catch (Exception e) {
                LOG.error("Received an exception during stream processing, backing off and retrying", (Throwable)e);
                this.giveUpPartition(streamPartition);
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException ex) {
                    LOG.info("The StreamScheduler was interrupted while waiting to retry, stopping processing");
                    break;
                }
            }
        }
    }

    public void shutdown() {
        if (this.streamWorkerTaskRefresher != null) {
            LOG.debug("Shutting down StreamWorkerTaskRefresher");
            this.streamWorkerTaskRefresher.shutdown();
        }
        this.shutdownRequested = true;
    }

    private void giveUpPartition(StreamPartition streamPartition) {
        if (streamPartition != null) {
            if (this.sourceConfig.isDisableS3ReadForLeader()) {
                System.clearProperty("STOP_S3_SCAN_PROCESSING");
            }
            this.sourceCoordinator.giveUpPartition((EnhancedSourcePartition)streamPartition);
        }
    }
}

