/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.datatype.postgres.handler;

import java.sql.SQLException;
import java.util.HashMap;
import org.opensearch.dataprepper.plugins.source.rds.datatype.postgres.PostgresDataType;
import org.opensearch.dataprepper.plugins.source.rds.datatype.postgres.PostgresDataTypeHandler;
import org.opensearch.dataprepper.plugins.source.rds.utils.PgArrayParser;
import org.postgresql.util.PGmoney;

public class NumericTypeHandler
implements PostgresDataTypeHandler {
    private static final String NAN = "nan";
    private static final String INFINITY = "infinity";
    private static final String NEGATIVE_INFINITY = "-infinity";

    @Override
    public Object handle(PostgresDataType columnType, String columnName, Object value) {
        if (!columnType.isNumeric()) {
            throw new IllegalArgumentException("ColumnType is not numeric: " + String.valueOf((Object)columnType));
        }
        if (columnType.isSubCategoryArray()) {
            return PgArrayParser.parseTypedArray(value.toString(), PostgresDataType.getScalarType(columnType), this::parseNumericValue);
        }
        return this.parseNumericValue(columnType, value.toString());
    }

    private Object parseNumericValue(PostgresDataType columnType, String textValue) {
        switch (columnType) {
            case SMALLINT: 
            case SMALLSERIAL: {
                return Short.parseShort(textValue);
            }
            case INTEGER: 
            case SERIAL: {
                return Integer.parseInt(textValue);
            }
            case BIGINT: 
            case BIGSERIAL: {
                return Long.parseLong(textValue);
            }
            case REAL: {
                return this.parseRealValue(textValue);
            }
            case DOUBLE_PRECISION: {
                return this.parseDoublePrecisionValue(textValue);
            }
            case NUMERIC: {
                return textValue;
            }
            case MONEY: {
                return this.parseMoney(textValue);
            }
        }
        return textValue;
    }

    private Object parseRealValue(String textValue) {
        switch (textValue.toLowerCase()) {
            case "nan": {
                return Float.valueOf(Float.NaN);
            }
            case "infinity": {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
            case "-infinity": {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
        }
        return Float.valueOf(Float.parseFloat(textValue));
    }

    private Object parseDoublePrecisionValue(String textValue) {
        switch (textValue.toLowerCase()) {
            case "nan": {
                return Double.NaN;
            }
            case "infinity": {
                return Double.POSITIVE_INFINITY;
            }
            case "-infinity": {
                return Double.NEGATIVE_INFINITY;
            }
        }
        return Double.parseDouble(textValue);
    }

    private Object parseMoney(String textValue) {
        try {
            boolean isNegative;
            boolean bl = isNegative = textValue.charAt(0) == '-';
            if (isNegative) {
                textValue = textValue.substring(1);
            }
            char currencySymbol = textValue.charAt(0);
            PGmoney money = new PGmoney(textValue);
            double value = isNegative ? -money.val : money.val;
            HashMap<String, Comparable<Character>> moneyMap = new HashMap<String, Comparable<Character>>();
            moneyMap.put("currency", Character.valueOf(currencySymbol));
            moneyMap.put("amount", Double.valueOf(value));
            return moneyMap;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error parsing String to PGmoney object", e);
        }
    }
}

