/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.personalize.dataset;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum DatasetTypeOptions {
    USERS("users"),
    ITEMS("items"),
    INTERACTIONS("interactions");

    private final String option;
    private static final Map<String, DatasetTypeOptions> OPTIONS_MAP;

    private DatasetTypeOptions(String option) {
        this.option = option.toLowerCase();
    }

    @JsonCreator
    static DatasetTypeOptions fromOptionValue(String option) {
        return OPTIONS_MAP.get(option);
    }

    static {
        OPTIONS_MAP = Arrays.stream(DatasetTypeOptions.values()).collect(Collectors.toMap(value -> value.option, value -> value));
    }
}

