/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.otlp.http;

import java.net.URI;
import javax.annotation.Nonnull;
import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.plugins.sink.otlp.configuration.OtlpSinkConfig;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.params.Aws4SignerParams;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.regions.Region;

class SigV4Signer {
    private static final String SERVICE_NAME = "xray";
    private static final String OTLP_PATH = "/v1/traces";
    private final Aws4Signer signer = Aws4Signer.create();
    private final AwsCredentialsProvider credentialsProvider;
    private final Region region;
    private final URI endpointUri;

    SigV4Signer(@Nonnull AwsCredentialsSupplier awsCredentialsSupplier, @Nonnull OtlpSinkConfig config) {
        this.region = config.getAwsRegion();
        this.credentialsProvider = awsCredentialsSupplier.getProvider(AwsCredentialsOptions.builder().withRegion(this.region).withStsRoleArn(config.getStsRoleArn()).withStsExternalId(config.getStsExternalId()).build());
        this.endpointUri = config.getEndpoint() != null ? URI.create(config.getEndpoint()) : URI.create(String.format("https://xray.%s.amazonaws.com%s", this.region.id(), OTLP_PATH));
    }

    SdkHttpFullRequest signRequest(@Nonnull byte[] payload) {
        SdkHttpFullRequest unsignedRequest = SdkHttpFullRequest.builder().method(SdkHttpMethod.POST).uri(this.endpointUri).putHeader("Content-Type", "application/x-protobuf").putHeader("Content-Encoding", "gzip").contentStreamProvider(() -> SdkBytes.fromByteArray((byte[])payload).asInputStream()).build();
        return this.signer.sign(unsignedRequest, Aws4SignerParams.builder().signingRegion(this.region).signingName(SERVICE_NAME).awsCredentials(this.credentialsProvider.resolveCredentials()).build());
    }
}

