/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.otlp;

import java.util.Collection;
import javax.annotation.Nonnull;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.annotations.Experimental;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.sink.AbstractSink;
import org.opensearch.dataprepper.model.sink.Sink;
import org.opensearch.dataprepper.model.trace.Span;
import org.opensearch.dataprepper.plugins.sink.otlp.buffer.OtlpSinkBuffer;
import org.opensearch.dataprepper.plugins.sink.otlp.configuration.OtlpSinkConfig;
import org.opensearch.dataprepper.plugins.sink.otlp.metrics.OtlpSinkMetrics;

@Experimental
@DataPrepperPlugin(name="otlp", pluginType=Sink.class, pluginConfigurationType=OtlpSinkConfig.class)
public class OtlpSink
extends AbstractSink<Record<Span>> {
    private volatile boolean initialized = false;
    private final OtlpSinkBuffer buffer;
    private final OtlpSinkMetrics sinkMetrics;

    @DataPrepperPluginConstructor
    public OtlpSink(@Nonnull AwsCredentialsSupplier awsCredentialsSupplier, @Nonnull OtlpSinkConfig config, @Nonnull PluginMetrics pluginMetrics, @Nonnull PluginSetting pluginSetting) {
        super(pluginSetting);
        this.sinkMetrics = new OtlpSinkMetrics(pluginMetrics, pluginSetting);
        this.buffer = new OtlpSinkBuffer(awsCredentialsSupplier, config, this.sinkMetrics);
    }

    public void doInitialize() {
        this.buffer.start();
        this.initialized = true;
    }

    public void doOutput(@Nonnull Collection<Record<Span>> records) {
        for (Record<Span> record : records) {
            this.buffer.add(record);
        }
    }

    public boolean isReady() {
        return this.initialized && this.buffer.isRunning();
    }

    public void shutdown() {
        super.shutdown();
        this.buffer.stop();
    }
}

