/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.mongo.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.Arrays;
import java.util.stream.Collectors;

public class CollectionConfig {
    private static final String COLLECTION_SPLITTER = "\\.";
    private static final int DEFAULT_STREAM_BATCH_SIZE = 1000;
    private static final int DEFAULT_PARTITION_COUNT = 100;
    private static final int DEFAULT_EXPORT_BATCH_SIZE = 10000;
    @JsonProperty(value="collection")
    @Pattern(regexp=".+?\\..+", message="Should be of pattern <database>.<collection>")
    @NotNull
    private @Pattern(regexp=".+?\\..+", message="Should be of pattern <database>.<collection>") @NotNull String collection;
    @JsonProperty(value="export")
    private boolean export = true;
    @JsonProperty(value="stream")
    private boolean stream = true;
    @JsonProperty(value="partition_count")
    @Min(value=1L)
    @Max(value=1000L)
    private @Min(value=1L) @Max(value=1000L) int partitionCount = 100;
    @JsonProperty(value="export_batch_size")
    @Min(value=1L)
    @Max(value=1000000L)
    private @Min(value=1L) @Max(value=1000000L) int exportBatchSize = 10000;
    @JsonProperty(value="stream_batch_size")
    @Min(value=1L)
    @Max(value=1000000L)
    private @Min(value=1L) @Max(value=1000000L) int streamBatchSize = 1000;

    public String getCollection() {
        return this.collection;
    }

    public String getDatabaseName() {
        return (String)Arrays.stream(this.collection.split(COLLECTION_SPLITTER)).collect(Collectors.toList()).get(0);
    }

    public String getCollectionName() {
        return (String)Arrays.stream(this.collection.split(COLLECTION_SPLITTER)).collect(Collectors.toList()).get(1);
    }

    public boolean isExport() {
        return this.export;
    }

    public boolean isStream() {
        return this.stream;
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public int getExportBatchSize() {
        return this.exportBatchSize;
    }

    public int getStreamBatchSize() {
        return this.streamBatchSize;
    }
}

