/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.microsoft_office365;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import org.hibernate.validator.constraints.time.DurationMax;
import org.opensearch.dataprepper.plugins.source.microsoft_office365.auth.AuthenticationConfiguration;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.CrawlerSourceConfig;

public class Office365SourceConfig
implements CrawlerSourceConfig {
    private static final int NUMBER_OF_WORKERS = 4;
    @NotNull
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @NotNull
    @JsonProperty(value="authentication")
    @Valid
    private AuthenticationConfiguration authenticationConfiguration;
    @JsonProperty(value="acknowledgments")
    private boolean acknowledgments = false;
    @JsonProperty(value="range")
    @DurationMax(days=7L, message="Range cannot exceed 7 days due to Office 365 API limitation")
    private @DurationMax(days=7L, message="Range cannot exceed 7 days due to Office 365 API limitation") Duration range;

    public int getLookBackHours() {
        if (this.range == null || this.range.toHours() <= 0L) {
            return 0;
        }
        return (int)this.range.toHours();
    }

    public int getNumberOfWorkers() {
        return 4;
    }

    public boolean isAcknowledgments() {
        return this.acknowledgments;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public AuthenticationConfiguration getAuthenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    public Duration getRange() {
        return this.range;
    }
}

