/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.microsoft_office365;

import io.micrometer.core.instrument.Counter;
import java.util.List;
import java.util.function.Supplier;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;

public class RetryHandler {
    private static final Logger log = LoggerFactory.getLogger(RetryHandler.class);
    public static final List<Integer> RETRY_ATTEMPT_SLEEP_TIME = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(5), Integer.valueOf(10), Integer.valueOf(20), Integer.valueOf(40));
    private static final int MAX_RETRIES = 6;
    private static final int SLEEP_TIME_MULTIPLIER = 1000;

    public static <T> T executeWithRetry(Supplier<T> operation, Runnable credentialRenewal) {
        return RetryHandler.executeWithRetry(operation, credentialRenewal, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeWithRetry(Supplier<T> operation, Runnable credentialRenewal, Counter failureCounter) {
        for (int retryCount = 0; retryCount < 6; ++retryCount) {
            boolean operationSucceeded = false;
            try {
                T result = operation.get();
                operationSucceeded = true;
                T t = result;
                return t;
            }
            catch (HttpClientErrorException | HttpServerErrorException ex) {
                HttpStatus statusCode = ex.getStatusCode();
                String statusMessage = ex.getMessage();
                switch (statusCode) {
                    case UNAUTHORIZED: {
                        log.error(DataPrepperMarkers.NOISY, "Token expired. Attempting to renew credentials.", ex);
                        credentialRenewal.run();
                        break;
                    }
                    case FORBIDDEN: {
                        log.error(DataPrepperMarkers.NOISY, "Access forbidden: {}", (Object)statusMessage, (Object)ex);
                        throw new SecurityException("Access forbidden: " + statusMessage);
                    }
                    case TOO_MANY_REQUESTS: {
                        log.error(DataPrepperMarkers.NOISY, "Hitting API rate limit. Backing off with sleep timer.", ex);
                        break;
                    }
                    case SERVICE_UNAVAILABLE: {
                        log.error(DataPrepperMarkers.NOISY, "Service is unavailable. Will retry after backing off.", ex);
                        break;
                    }
                    default: {
                        if (ex.getStatusCode().is4xxClientError()) {
                            log.error(DataPrepperMarkers.NOISY, "Client error: {}. Will not retry.", (Object)statusCode, (Object)ex);
                            throw ex;
                        }
                        if (ex.getStatusCode().is5xxServerError()) {
                            log.error(DataPrepperMarkers.NOISY, "Server error: {}. Will retry after backing off.", (Object)statusCode, (Object)ex);
                            break;
                        }
                        throw ex;
                    }
                }
                if (retryCount == 5) {
                    log.error(DataPrepperMarkers.NOISY, "Exceeded maximum retry attempts.", ex);
                    throw ex;
                }
                try {
                    Thread.sleep((long)RETRY_ATTEMPT_SLEEP_TIME.get(retryCount).intValue() * 1000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Retry interrupted", ie);
                }
            }
            finally {
                if (!operationSucceeded && failureCounter != null) {
                    failureCounter.increment();
                }
            }
        }
        throw new RuntimeException("Exceeded max retry attempts");
    }
}

