/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.microsoft_office365;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.inject.Named;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventType;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.source.microsoft_office365.Office365SourceConfig;
import org.opensearch.dataprepper.plugins.source.microsoft_office365.models.AuditLogsResponse;
import org.opensearch.dataprepper.plugins.source.microsoft_office365.service.Office365Service;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.CrawlerClient;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.state.DimensionalTimeSliceWorkerProgressState;
import org.opensearch.dataprepper.plugins.source.source_crawler.exception.SaaSCrawlerException;
import org.opensearch.dataprepper.plugins.source.source_crawler.model.ItemInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class Office365CrawlerClient
implements CrawlerClient<DimensionalTimeSliceWorkerProgressState> {
    private static final Logger log = LoggerFactory.getLogger(Office365CrawlerClient.class);
    public static final String NON_RETRYABLE_ERRORS = "nonRetryableErrors";
    public static final String RETRYABLE_ERRORS = "retryableErrors";
    private static final String BUFFER_WRITE_LATENCY = "bufferWriteLatency";
    private static final String BUFFER_WRITE_ATTEMPTS = "bufferWriteAttempts";
    private static final String BUFFER_WRITE_SUCCESS = "bufferWriteSuccess";
    private static final String BUFFER_WRITE_RETRY_SUCCESS = "bufferWriteRetrySuccess";
    private static final String BUFFER_WRITE_RETRY_ATTEMPTS = "bufferWriteRetryAttempts";
    private static final String BUFFER_WRITE_FAILURES = "bufferWriteFailures";
    private static final int BUFFER_TIMEOUT_IN_SECONDS = 10;
    private static final String CONTENT_ID = "contentId";
    private static final String CONTENT_URI = "contentUri";
    private final Office365Service service;
    private final Office365SourceConfig configuration;
    private final Timer bufferWriteLatencyTimer;
    private final Counter bufferWriteAttemptsCounter;
    private final Counter bufferWriteSuccessCounter;
    private final Counter bufferWriteRetrySuccessCounter;
    private final Counter bufferWriteRetryAttemptsCounter;
    private final Counter bufferWriteFailuresCounter;
    private final Counter requestErrorsCounter;
    private final Counter nonRetryableErrorsCounter;
    private final Counter retryableErrorsCounter;
    private ObjectMapper objectMapper;

    public Office365CrawlerClient(Office365Service service, Office365SourceConfig sourceConfig, PluginMetrics pluginMetrics) {
        this.service = service;
        this.configuration = sourceConfig;
        this.objectMapper = new ObjectMapper();
        this.bufferWriteLatencyTimer = pluginMetrics.timer(BUFFER_WRITE_LATENCY);
        this.bufferWriteAttemptsCounter = pluginMetrics.counter(BUFFER_WRITE_ATTEMPTS);
        this.bufferWriteSuccessCounter = pluginMetrics.counter(BUFFER_WRITE_SUCCESS);
        this.bufferWriteRetrySuccessCounter = pluginMetrics.counter(BUFFER_WRITE_RETRY_SUCCESS);
        this.bufferWriteRetryAttemptsCounter = pluginMetrics.counter(BUFFER_WRITE_RETRY_ATTEMPTS);
        this.bufferWriteFailuresCounter = pluginMetrics.counter(BUFFER_WRITE_FAILURES);
        this.requestErrorsCounter = pluginMetrics.counter("requestErrors");
        this.nonRetryableErrorsCounter = pluginMetrics.counter(NON_RETRYABLE_ERRORS);
        this.retryableErrorsCounter = pluginMetrics.counter(RETRYABLE_ERRORS);
    }

    @VisibleForTesting
    void injectObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Iterator<ItemInfo> listItems(Instant lastPollTime) {
        return null;
    }

    public void executePartition(DimensionalTimeSliceWorkerProgressState state, Buffer<Record<Event>> buffer, AcknowledgementSet acknowledgementSet) {
        Instant startTime = state.getStartTime();
        Instant endTime = state.getEndTime();
        String logType = state.getDimensionType();
        try {
            AuditLogsResponse response;
            String nextPageUri = null;
            do {
                ArrayList<Record<Event>> records = new ArrayList<Record<Event>>();
                response = this.service.searchAuditLogs(logType, startTime, endTime, nextPageUri);
                if (response.getItems() != null && !response.getItems().isEmpty()) {
                    for (Map<String, Object> metadata : response.getItems()) {
                        String logId = (String)metadata.get(CONTENT_ID);
                        try {
                            Record<Event> record = this.processAuditLog(metadata);
                            if (record == null) continue;
                            records.add(record);
                        }
                        catch (SaaSCrawlerException e) {
                            boolean isRetryable = e.isRetryable();
                            log.error(DataPrepperMarkers.NOISY, "{} error processing audit log: {}", new Object[]{isRetryable ? "Retryable" : "Non-retryable", logId, e});
                            throw new SaaSCrawlerException("Error processing audit log: " + logId, (Throwable)e, isRetryable);
                        }
                    }
                }
                this.bufferWriteLatencyTimer.record(() -> {
                    try {
                        this.writeRecordsWithRetry(records, buffer, acknowledgementSet);
                    }
                    catch (Exception e) {
                        this.bufferWriteFailuresCounter.increment();
                        throw e;
                    }
                });
            } while ((nextPageUri = response.getNextPageUri()) != null);
            if (this.configuration.isAcknowledgments()) {
                acknowledgementSet.complete();
            }
        }
        catch (Exception e) {
            log.error(DataPrepperMarkers.NOISY, "Failed to process partition for log type {} from {} to {}", new Object[]{logType, startTime, endTime, e});
            this.requestErrorsCounter.increment();
            if (e instanceof SaaSCrawlerException) {
                SaaSCrawlerException saasException = (SaaSCrawlerException)((Object)e);
                if (saasException.isRetryable()) {
                    this.retryableErrorsCounter.increment();
                } else {
                    this.nonRetryableErrorsCounter.increment();
                }
                throw e;
            }
            this.nonRetryableErrorsCounter.increment();
            throw new SaaSCrawlerException("Failed to process partition", (Throwable)e, false);
        }
    }

    private Record<Event> processAuditLog(Map<String, Object> metadata) throws SaaSCrawlerException {
        String contentUri = (String)metadata.get(CONTENT_URI);
        if (contentUri == null) {
            throw new SaaSCrawlerException("Missing contentUri in metadata", false);
        }
        String logContent = this.service.getAuditLog(contentUri);
        if (logContent == null) {
            throw new SaaSCrawlerException("Received null log content for URI: " + contentUri, false);
        }
        String logId = (String)metadata.get(CONTENT_ID);
        try {
            JsonNode jsonNode = this.objectMapper.readTree(logContent);
            Map data = jsonNode.isArray() && !jsonNode.isEmpty() ? (Map)this.objectMapper.convertValue((Object)jsonNode.get(0), (TypeReference)new TypeReference<Map<String, Object>>(){}) : (Map)this.objectMapper.readValue(logContent, (TypeReference)new TypeReference<Map<String, Object>>(){});
            String contentType = (String)data.get("Workload");
            if (contentType == null) {
                throw new SaaSCrawlerException("Missing Workload field in audit log: " + logId, false);
            }
            JacksonEvent event = JacksonEvent.builder().withEventType(EventType.LOG.toString()).withData((Object)data).build();
            event.getMetadata().setAttribute("contentType", (Object)contentType);
            return new Record((Object)event);
        }
        catch (JsonProcessingException e) {
            throw new SaaSCrawlerException("Failed to parse audit log: " + logId, (Throwable)e, false);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void writeRecordsWithRetry(List<Record<Event>> records, Buffer<Record<Event>> buffer, AcknowledgementSet acknowledgementSet) {
        this.bufferWriteAttemptsCounter.increment();
        retryCount = 0;
        currentBackoff = 1000;
        maxBackoff = 30000;
        maxRetries = 5;
        while (true) lbl-1000:
        // 2 sources

        {
            try {
                if (this.configuration.isAcknowledgments()) {
                    records.forEach((Consumer<Record>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$writeRecordsWithRetry$1(org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet org.opensearch.dataprepper.model.record.Record ), (Lorg/opensearch/dataprepper/model/record/Record;)V)((AcknowledgementSet)acknowledgementSet));
                    buffer.writeAll(records, (int)Duration.ofSeconds(10L).toMillis());
                } else {
                    buffer.writeAll(records, (int)Duration.ofSeconds(10L).toMillis());
                }
                if (retryCount > 0) {
                    this.bufferWriteRetrySuccessCounter.increment();
                } else {
                    this.bufferWriteSuccessCounter.increment();
                }
                return;
            }
            catch (TimeoutException e) {
                if (++retryCount >= 5) {
                    this.bufferWriteFailuresCounter.increment();
                    throw new SaaSCrawlerException("Failed to write to buffer after 5 attempts", (Throwable)e, true);
                }
                this.bufferWriteRetryAttemptsCounter.increment();
                currentBackoff = Math.min((int)((double)currentBackoff * 2.0), 30000);
                Office365CrawlerClient.log.info("Buffer full, backing off for {} ms before retry", (Object)currentBackoff);
                try {
                    Thread.sleep(currentBackoff);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new SaaSCrawlerException("Buffer write retry interrupted", (Throwable)ie, true);
                }
            }
            ** while (true)
            catch (Exception e) {
                this.bufferWriteFailuresCounter.increment();
                throw new SaaSCrawlerException("Error writing to buffer", (Throwable)e, true);
            }
            break;
        }
    }

    private static /* synthetic */ void lambda$writeRecordsWithRetry$1(AcknowledgementSet acknowledgementSet, Record record) {
        acknowledgementSet.add((Event)record.getData());
    }
}

