/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class JsonUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public boolean isJsonNodeDifferent(JsonNode oldNode, JsonNode newNode) {
        if (oldNode.isObject() && newNode.isObject()) {
            ObjectNode objNode1 = (ObjectNode)oldNode;
            ObjectNode objNode2 = (ObjectNode)newNode;
            return !objNode1.equals((Object)objNode2);
        }
        return !oldNode.equals((Object)newNode);
    }

    public JsonNode getJsonNode(String value) throws JsonProcessingException {
        return objectMapper.readTree(value);
    }

    public <T> T getReadValue(InputStream value, TypeReference<T> type) throws IOException {
        return (T)objectMapper.readValue(value, type);
    }

    public <T> T getReadValue(File value, Class<T> type) throws IOException {
        return (T)objectMapper.readValue(value, type);
    }

    public String getJsonValue(Object value) throws JsonProcessingException {
        return objectMapper.writeValueAsString(value);
    }
}

