/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.source;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.time.Duration;
import org.opensearch.dataprepper.model.types.ByteCount;
import org.opensearch.dataprepper.plugins.kafka.configuration.CommonTopicConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.IsolationLevel;
import org.opensearch.dataprepper.plugins.kafka.configuration.KafkaIsolationLevelConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.KafkaKeyMode;
import org.opensearch.dataprepper.plugins.kafka.configuration.KmsConfig;
import org.opensearch.dataprepper.plugins.kafka.configuration.TopicConsumerConfig;
import org.opensearch.dataprepper.plugins.kafka.util.MessageFormat;

class SourceTopicConfig
extends CommonTopicConfig
implements TopicConsumerConfig,
KafkaIsolationLevelConfig {
    static final boolean DEFAULT_AUTO_COMMIT = false;
    static final Duration DEFAULT_COMMIT_INTERVAL = Duration.ofSeconds(5L);
    static final String DEFAULT_FETCH_MAX_BYTES = "50mb";
    static final Integer DEFAULT_FETCH_MAX_WAIT = 500;
    static final String DEFAULT_FETCH_MIN_BYTES = "1b";
    static final String DEFAULT_MAX_PARTITION_FETCH_BYTES = "1mb";
    static final Duration DEFAULT_SESSION_TIMEOUT = Duration.ofSeconds(45L);
    static final String DEFAULT_AUTO_OFFSET_RESET = "earliest";
    static final Duration DEFAULT_THREAD_WAITING_TIME = Duration.ofSeconds(5L);
    static final Duration DEFAULT_MAX_POLL_INTERVAL = Duration.ofSeconds(300L);
    static final Integer DEFAULT_CONSUMER_MAX_POLL_RECORDS = 500;
    static final Integer DEFAULT_NUM_OF_WORKERS = 2;
    static final Duration DEFAULT_HEART_BEAT_INTERVAL_DURATION = Duration.ofSeconds(5L);
    @JsonProperty(value="serde_format")
    private MessageFormat serdeFormat = MessageFormat.PLAINTEXT;
    @JsonProperty(value="commit_interval")
    @Valid
    @Size(min=1)
    private @Valid @Size(min=1) Duration commitInterval = DEFAULT_COMMIT_INTERVAL;
    @JsonProperty(value="key_mode")
    private KafkaKeyMode kafkaKeyMode = KafkaKeyMode.INCLUDE_AS_FIELD;
    @JsonProperty(value="group_id")
    @Valid
    @Size(min=1, max=255, message="size of group id should be between 1 and 255")
    private @Valid @Size(min=1, max=255, message="size of group id should be between 1 and 255") String groupId;
    @JsonProperty(value="client_id")
    @Valid
    @Size(min=1, max=255, message="size of client id should be between 1 and 255")
    private @Valid @Size(min=1, max=255, message="size of client id should be between 1 and 255") String clientId;
    @JsonProperty(value="workers")
    @Valid
    @Size(min=1, max=200, message="Number of worker threads should lies between 1 and 200")
    private @Valid @Size(min=1, max=200, message="Number of worker threads should lies between 1 and 200") Integer workers = DEFAULT_NUM_OF_WORKERS;
    @JsonProperty(value="session_timeout")
    @Valid
    @Size(min=1)
    private @Valid @Size(min=1) Duration sessionTimeOut = DEFAULT_SESSION_TIMEOUT;
    @JsonProperty(value="auto_offset_reset")
    private String autoOffsetReset = "earliest";
    @JsonProperty(value="thread_waiting_time")
    private Duration threadWaitingTime = DEFAULT_THREAD_WAITING_TIME;
    @JsonProperty(value="max_poll_interval")
    private Duration maxPollInterval = DEFAULT_MAX_POLL_INTERVAL;
    @JsonProperty(value="consumer_max_poll_records")
    private Integer consumerMaxPollRecords = DEFAULT_CONSUMER_MAX_POLL_RECORDS;
    @JsonProperty(value="heart_beat_interval")
    @Valid
    @Size(min=1)
    private @Valid @Size(min=1) Duration heartBeatInterval = DEFAULT_HEART_BEAT_INTERVAL_DURATION;
    @JsonProperty(value="auto_commit")
    private Boolean autoCommit = false;
    @JsonProperty(value="max_partition_fetch_bytes")
    private String maxPartitionFetchBytes = "1mb";
    @JsonProperty(value="fetch_max_bytes")
    private String fetchMaxBytes = "50mb";
    @JsonProperty(value="fetch_max_wait")
    @Valid
    @Size(min=1)
    private @Valid @Size(min=1) Integer fetchMaxWait = DEFAULT_FETCH_MAX_WAIT;
    @JsonProperty(value="fetch_min_bytes")
    private String fetchMinBytes = "1b";
    @JsonProperty(value="isolation_level")
    private IsolationLevel isolationLevel = IsolationLevel.READ_UNCOMMITTED;

    SourceTopicConfig() {
    }

    @Override
    public String getEncryptionId() {
        return null;
    }

    @Override
    public String getEncryptionKey() {
        return null;
    }

    @Override
    public KmsConfig getKmsConfig() {
        return null;
    }

    @Override
    public Duration getCommitInterval() {
        return this.commitInterval;
    }

    @Override
    public KafkaKeyMode getKafkaKeyMode() {
        return this.kafkaKeyMode;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public MessageFormat getSerdeFormat() {
        return this.serdeFormat;
    }

    @Override
    public Boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(Boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    @Override
    public long getFetchMaxBytes() {
        long value = ByteCount.parse((String)this.fetchMaxBytes).getBytes();
        if (value < 1L || value > 0x3200000L) {
            throw new RuntimeException("Invalid Fetch Max Bytes");
        }
        return value;
    }

    @Override
    public Integer getFetchMaxWait() {
        return this.fetchMaxWait;
    }

    @Override
    public long getFetchMinBytes() {
        long value = ByteCount.parse((String)this.fetchMinBytes).getBytes();
        if (value < 1L) {
            throw new RuntimeException("Invalid Fetch Min Bytes");
        }
        return value;
    }

    @Override
    public long getMaxPartitionFetchBytes() {
        return ByteCount.parse((String)this.maxPartitionFetchBytes).getBytes();
    }

    @Override
    public Duration getSessionTimeOut() {
        return this.sessionTimeOut;
    }

    @Override
    public String getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    @Override
    public Duration getThreadWaitingTime() {
        return this.threadWaitingTime;
    }

    @Override
    public Duration getMaxPollInterval() {
        return this.maxPollInterval;
    }

    @Override
    public Integer getConsumerMaxPollRecords() {
        return this.consumerMaxPollRecords;
    }

    @Override
    public Integer getWorkers() {
        return this.workers;
    }

    @Override
    public Duration getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    @Override
    public IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }
}

