/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.util;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum AuthenticationType {
    PLAINTEXT("plaintext"),
    SSL("ssl"),
    OAUTH("oauth");

    private static final Map<String, AuthenticationType> AUTHENTICATION_TYPE_MAP;
    private final String authType;

    private AuthenticationType(String authType) {
        this.authType = authType;
    }

    public String toString() {
        return this.authType;
    }

    public static AuthenticationType getAuthTypeByName(String name) {
        return AUTHENTICATION_TYPE_MAP.get(name.toLowerCase());
    }

    static {
        AUTHENTICATION_TYPE_MAP = Arrays.stream(AuthenticationType.values()).collect(Collectors.toMap(AuthenticationType::toString, Function.identity()));
    }
}

