/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.opensearch.dataprepper.plugins.kafka.configuration.KafkaProducerConfig;
import org.opensearch.dataprepper.plugins.kafka.util.SinkPropertyConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicService {
    private static final Logger LOG = LoggerFactory.getLogger(TopicService.class);
    private final AdminClient adminClient;

    TopicService(KafkaProducerConfig kafkaProducerConfig) {
        this.adminClient = AdminClient.create((Properties)SinkPropertyConfigurer.getPropertiesForAdminClient(kafkaProducerConfig));
    }

    public void createTopic(String topicName, Integer numberOfPartitions, Short replicationFactor, Long maxMessageBytes) {
        try {
            NewTopic newTopic = new NewTopic(topicName, numberOfPartitions.intValue(), replicationFactor.shortValue());
            if (maxMessageBytes != null) {
                HashMap<String, String> configOptions = new HashMap<String, String>();
                configOptions.put("max.message.bytes", Long.toString(maxMessageBytes));
                newTopic.configs(configOptions);
            }
            this.adminClient.createTopics(Collections.singletonList(newTopic)).all().get();
            LOG.info(topicName + " created successfully");
        }
        catch (Exception e) {
            LOG.error("Caught exception creating topic with name: {}", (Object)topicName, (Object)e);
        }
    }

    public void closeAdminClient() {
        this.adminClient.close();
    }
}

