/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.util;

import java.util.Map;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.opensearch.dataprepper.metrics.PluginMetrics;

public final class KafkaProducerMetrics {
    static final Map<String, String> METRICS_NAME_MAP = Map.of("record-queue-time-avg", "recordQueueTimeAvg", "record-queue-time-max", "recordQueueTimeMax", "buffer-exhausted-rate", "bufferExhaustedRate", "buffer-available-bytes", "bufferAvailableBytes");

    private KafkaProducerMetrics() {
    }

    public static void registerProducer(PluginMetrics pluginMetrics, KafkaProducer<?, ?> kafkaProducer) {
        Map kafkaProducerMetrics = kafkaProducer.metrics();
        for (Map.Entry metricNameEntry : kafkaProducerMetrics.entrySet()) {
            MetricName kafkaMetricName = (MetricName)metricNameEntry.getKey();
            String dataPrepperMetricName = METRICS_NAME_MAP.get(kafkaMetricName.name());
            if (dataPrepperMetricName == null) continue;
            Metric metric = (Metric)metricNameEntry.getValue();
            pluginMetrics.gauge(dataPrepperMetricName, (Object)metric, m -> (Double)m.metricValue());
        }
    }
}

