/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.jira;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventType;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.source.jira.JiraItemInfo;
import org.opensearch.dataprepper.plugins.source.jira.JiraIterator;
import org.opensearch.dataprepper.plugins.source.jira.JiraService;
import org.opensearch.dataprepper.plugins.source.jira.JiraSourceConfig;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.CrawlerClient;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.CrawlerSourceConfig;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.PluginExecutorServiceProvider;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.state.PaginationCrawlerWorkerProgressState;
import org.opensearch.dataprepper.plugins.source.source_crawler.model.ItemInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class JiraClient
implements CrawlerClient<PaginationCrawlerWorkerProgressState> {
    private static final Logger log = LoggerFactory.getLogger(JiraClient.class);
    private ObjectMapper objectMapper = new ObjectMapper();
    private final JiraService service;
    private final JiraIterator jiraIterator;
    private final ExecutorService executorService;
    private final CrawlerSourceConfig configuration;
    private final int bufferWriteTimeoutInSeconds = 10;

    public JiraClient(JiraService service, JiraIterator jiraIterator, PluginExecutorServiceProvider executorServiceProvider, JiraSourceConfig sourceConfig) {
        this.service = service;
        this.jiraIterator = jiraIterator;
        this.executorService = executorServiceProvider.get();
        this.configuration = sourceConfig;
    }

    public Iterator<ItemInfo> listItems(Instant lastPollTime) {
        this.jiraIterator.initialize(lastPollTime);
        return this.jiraIterator;
    }

    @VisibleForTesting
    void injectObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void executePartition(PaginationCrawlerWorkerProgressState state, Buffer<Record<Event>> buffer, AcknowledgementSet acknowledgementSet) {
        log.trace("Executing the partition: {} with {} ticket(s)", (Object)state.getKeyAttributes(), (Object)state.getItemIds().size());
        List itemIds = state.getItemIds();
        Map keyAttributes = state.getKeyAttributes();
        String project = (String)keyAttributes.get("project");
        Instant eventTime = state.getExportStartTime();
        ArrayList<JiraItemInfo> itemInfos = new ArrayList<JiraItemInfo>();
        for (String itemId : itemIds) {
            if (itemId == null) continue;
            JiraItemInfo itemInfo = JiraItemInfo.builder().withItemId(itemId).withId(itemId).withProject(project).withEventTime(eventTime).withMetadata(keyAttributes).build();
            itemInfos.add(itemInfo);
        }
        String eventType = EventType.DOCUMENT.toString();
        List<Record> recordsToWrite = itemInfos.parallelStream().map(t -> () -> this.service.getIssue(t.getId())).map(supplier -> CompletableFuture.supplyAsync(supplier, this.executorService)).map(CompletableFuture::join).map(ticketJson -> {
            try {
                return this.objectMapper.readValue(ticketJson, (TypeReference)new TypeReference<Object>(){});
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }).map(t -> JacksonEvent.builder().withEventType(eventType).withData(t).build()).map(Record::new).peek(record -> ((Event)record.getData()).getMetadata().setAttribute("project", (Object)project.toLowerCase())).collect(Collectors.toList());
        try {
            if (this.configuration.isAcknowledgments()) {
                recordsToWrite.forEach(eventRecord -> acknowledgementSet.add((Event)eventRecord.getData()));
                buffer.writeAll(recordsToWrite, (int)Duration.ofSeconds(10L).toMillis());
                acknowledgementSet.complete();
            } else {
                buffer.writeAll(recordsToWrite, (int)Duration.ofSeconds(10L).toMillis());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

